rule win_mosquito_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mosquito."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mosquito"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d8 1bc0 83e0b4 83c04c }
            // n = 4, score = 400
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e0b4               | and                 eax, 0xffffffb4
            //   83c04c               | add                 eax, 0x4c

        $sequence_1 = { 52 50 6a00 6801c1fd7d }
            // n = 4, score = 400
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6801c1fd7d           | push                0x7dfdc101

        $sequence_2 = { 8bfc f3a5 ff942464020000 81c450020000 }
            // n = 4, score = 400
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff942464020000       | call                dword ptr [esp + 0x264]
            //   81c450020000         | add                 esp, 0x250

        $sequence_3 = { 894b02 8bcf 8b17 ff5208 }
            // n = 4, score = 300
            //   894b02               | mov                 dword ptr [ebx + 2], ecx
            //   8bcf                 | mov                 ecx, edi
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   ff5208               | call                dword ptr [edx + 8]

        $sequence_4 = { 8b750c 57 894dfc 8d5e06 53 e8???????? 8bf8 }
            // n = 7, score = 300
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8d5e06               | lea                 ebx, [esi + 6]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { ff5010 85c0 7436 837dfc00 7409 }
            // n = 5, score = 300
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   85c0                 | test                eax, eax
            //   7436                 | je                  0x38
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7409                 | je                  0xb

        $sequence_6 = { f3a5 ff942460020000 81c450020000 85c0 }
            // n = 4, score = 300
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff942460020000       | call                dword ptr [esp + 0x260]
            //   81c450020000         | add                 esp, 0x250
            //   85c0                 | test                eax, eax

        $sequence_7 = { e8???????? 6a20 8bf0 e8???????? 8bc8 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   6a20                 | push                0x20
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_8 = { 51 8b55fc 52 8b45f8 50 ff15???????? 8b4dfc }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_9 = { 6801c1fd7d e8???????? 8bd8 eb02 }
            // n = 4, score = 200
            //   6801c1fd7d           | push                0x7dfdc101
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   eb02                 | jmp                 4

        $sequence_10 = { e8???????? 83c40c e8???????? 6a20 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   6a20                 | push                0x20

        $sequence_11 = { 0000 006301 1000 7500 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   006301               | add                 byte ptr [ebx + 1], ah
            //   1000                 | adc                 byte ptr [eax], al
            //   7500                 | jne                 2

        $sequence_12 = { ff15???????? 6a00 56 ff15???????? 8903 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8903                 | mov                 dword ptr [ebx], eax

        $sequence_13 = { 0000 006500 676c 0010 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   006500               | add                 byte ptr [ebp], ah
            //   676c                 | insb                byte ptr es:[di], dx
            //   0010                 | add                 byte ptr [eax], dl

        $sequence_14 = { 0000 00645657 8b7dc2 0400 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   00645657             | add                 byte ptr [esi + edx*2 + 0x57], ah
            //   8b7dc2               | mov                 edi, dword ptr [ebp - 0x3e]
            //   0400                 | add                 al, 0

        $sequence_15 = { 0000 0032 08804d086440 5e }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0032                 | add                 byte ptr [edx], dh
            //   08804d086440         | or                  byte ptr [eax + 0x4064084d], al
            //   5e                   | pop                 esi

        $sequence_16 = { 0000 0001 1001 c550f0 8b8078005900 }
            // n = 5, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0001                 | add                 byte ptr [ecx], al
            //   1001                 | adc                 byte ptr [ecx], al
            //   c550f0               | lds                 edx, ptr [eax - 0x10]
            //   8b8078005900         | mov                 eax, dword ptr [eax + 0x590078]

        $sequence_17 = { 0000 0018 a0???????? 57 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0018                 | add                 byte ptr [eax], bl
            //   a0????????           |                     
            //   57                   | push                edi

        $sequence_18 = { 0000 00748078 3001 40 }
            // n = 4, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   00748078             | add                 byte ptr [eax + eax*4 + 0x78], dh
            //   3001                 | xor                 byte ptr [ecx], al
            //   40                   | inc                 eax

    condition:
        7 of them and filesize < 1015808
}