rule win_mount_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mount_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mount_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498be8 4d8bc8 4c8bc2 4c8bf2 }
            // n = 4, score = 500
            //   498be8               | mov                 dword ptr [esp + 0x30], 1
            //   4d8bc8               | mov                 dword ptr [esp + 0x3c], 2
            //   4c8bc2               | dec                 ecx
            //   4c8bf2               | mov                 ebp, eax

        $sequence_1 = { f30f5905???????? 0f5ad0 66490f7ed0 e8???????? }
            // n = 4, score = 500
            //   f30f5905????????     |                     
            //   0f5ad0               | dec                 ecx
            //   66490f7ed0           | mov                 ebp, eax
            //   e8????????           |                     

        $sequence_2 = { 8bc8 81e10000ffff 81f900000780 7503 0fb7c0 3d2e050000 }
            // n = 6, score = 500
            //   8bc8                 | xor                 edx, edx
            //   81e10000ffff         | mov                 dword ptr [esp + 0x30], 1
            //   81f900000780         | dec                 eax
            //   7503                 | mov                 ecx, dword ptr [ebx]
            //   0fb7c0               | inc                 ecx
            //   3d2e050000           | mov                 ecx, 2

        $sequence_3 = { 488b0b 41b902000000 4533c0 33d2 }
            // n = 4, score = 500
            //   488b0b               | dec                 esp
            //   41b902000000         | mov                 esi, edx
            //   4533c0               | mov                 esi, ecx
            //   33d2                 | xor                 edx, edx

        $sequence_4 = { 488d4df0 4889442428 4533c9 4533c0 }
            // n = 4, score = 500
            //   488d4df0             | mov                 ecx, 2
            //   4889442428           | inc                 ebp
            //   4533c9               | xor                 eax, eax
            //   4533c0               | xor                 edx, edx

        $sequence_5 = { 4c8bc2 4c8bf2 8bf1 33d2 33c9 }
            // n = 5, score = 500
            //   4c8bc2               | xor                 edx, edx
            //   4c8bf2               | mov                 dword ptr [esp + 0x30], 1
            //   8bf1                 | dec                 eax
            //   33d2                 | mov                 ecx, dword ptr [ebx]
            //   33c9                 | inc                 ecx

        $sequence_6 = { 4c8b05???????? 488bcb 488b15???????? e8???????? }
            // n = 4, score = 500
            //   4c8b05????????       |                     
            //   488bcb               | dec                 eax
            //   488b15????????       |                     
            //   e8????????           |                     

        $sequence_7 = { 4533c9 488b4c2458 33d2 c744243001000000 c744243c02000000 }
            // n = 5, score = 500
            //   4533c9               | inc                 ebp
            //   488b4c2458           | xor                 ecx, ecx
            //   33d2                 | dec                 eax
            //   c744243001000000     | mov                 ecx, dword ptr [esp + 0x58]
            //   c744243c02000000     | xor                 edx, edx

        $sequence_8 = { ff15???????? 85c0 7509 f0ff05???????? }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | xor                 edx, edx
            //   7509                 | mov                 dword ptr [esp + 0x30], 1
            //   f0ff05????????       |                     

        $sequence_9 = { 7505 e8???????? 833d????????00 7409 833d????????00 }
            // n = 5, score = 300
            //   7505                 | dec                 ebp
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7409                 | mov                 ecx, eax
            //   833d????????00       |                     

        $sequence_10 = { 7423 488b0d???????? 4885c9 7417 488364242000 4c8d4c2468 }
            // n = 6, score = 300
            //   7423                 | dec                 eax
            //   488b0d????????       |                     
            //   4885c9               | mov                 ecx, ebx
            //   7417                 | dec                 esp
            //   488364242000         | lea                 eax, [esp + 0x30]
            //   4c8d4c2468           | dec                 eax

        $sequence_11 = { 57 ff15???????? 8bd8 85db 7442 }
            // n = 5, score = 100
            //   57                   | mov                 esi, ecx
            //   ff15????????         |                     
            //   8bd8                 | xor                 edx, edx
            //   85db                 | dec                 ebp
            //   7442                 | mov                 ecx, eax

        $sequence_12 = { 66894df8 668945f4 56 56 }
            // n = 4, score = 100
            //   66894df8             | dec                 esp
            //   668945f4             | mov                 eax, edx
            //   56                   | dec                 esp
            //   56                   | mov                 esi, edx

        $sequence_13 = { 8b7c2414 8b35???????? bd???????? 8b15???????? 8bde 03df 89542414 }
            // n = 7, score = 100
            //   8b7c2414             | and                 ecx, 0xffff0000
            //   8b35????????         |                     
            //   bd????????           |                     
            //   8b15????????         |                     
            //   8bde                 | cmp                 ecx, 0x80070000
            //   03df                 | jne                 0x11
            //   89542414             | movzx               eax, ax

        $sequence_14 = { c3 6aff ff7508 e8???????? 68???????? }
            // n = 5, score = 100
            //   c3                   | cmp                 eax, 0x52e
            //   6aff                 | dec                 ebp
            //   ff7508               | mov                 ecx, eax
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_15 = { 59 59 5f 5e 33c0 5d }
            // n = 6, score = 100
            //   59                   | mov                 eax, edx
            //   59                   | dec                 esp
            //   5f                   | mov                 esi, edx
            //   5e                   | mov                 esi, ecx
            //   33c0                 | xor                 edx, edx
            //   5d                   | mov                 ecx, eax

    condition:
        7 of them and filesize < 368640
}