rule win_mozart_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mozart."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mozart"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 c644241800 eb26 8d4c2418 51 }
            // n = 5, score = 200
            //   33f6                 | xor                 esi, esi
            //   c644241800           | mov                 byte ptr [esp + 0x18], 0
            //   eb26                 | jmp                 0x28
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx

        $sequence_1 = { 8b542468 41 3bca 736e 8bd0 }
            // n = 5, score = 200
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   736e                 | jae                 0x70
            //   8bd0                 | mov                 edx, eax

        $sequence_2 = { 7c19 3c39 7f15 bd01000000 eb08 3c30 7c36 }
            // n = 7, score = 200
            //   7c19                 | jl                  0x1b
            //   3c39                 | cmp                 al, 0x39
            //   7f15                 | jg                  0x17
            //   bd01000000           | mov                 ebp, 1
            //   eb08                 | jmp                 0xa
            //   3c30                 | cmp                 al, 0x30
            //   7c36                 | jl                  0x38

        $sequence_3 = { 7471 c1e006 0bc7 a900000001 7425 }
            // n = 5, score = 200
            //   7471                 | je                  0x73
            //   c1e006               | shl                 eax, 6
            //   0bc7                 | or                  eax, edi
            //   a900000001           | test                eax, 0x1000000
            //   7425                 | je                  0x27

        $sequence_4 = { 0f84a0010000 48 0f84e6000000 48 0f85fd010000 85ed 7544 }
            // n = 7, score = 200
            //   0f84a0010000         | je                  0x1a6
            //   48                   | dec                 eax
            //   0f84e6000000         | je                  0xec
            //   48                   | dec                 eax
            //   0f85fd010000         | jne                 0x203
            //   85ed                 | test                ebp, ebp
            //   7544                 | jne                 0x46

        $sequence_5 = { 0fbe0a 8a89c8924000 0fb6f9 8bcf 42 83e940 }
            // n = 6, score = 200
            //   0fbe0a               | movsx               ecx, byte ptr [edx]
            //   8a89c8924000         | mov                 cl, byte ptr [ecx + 0x4092c8]
            //   0fb6f9               | movzx               edi, cl
            //   8bcf                 | mov                 ecx, edi
            //   42                   | inc                 edx
            //   83e940               | sub                 ecx, 0x40

        $sequence_6 = { 8a08 40 84c9 75f9 8b8c2420100000 }
            // n = 5, score = 200
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   8b8c2420100000       | mov                 ecx, dword ptr [esp + 0x1020]

        $sequence_7 = { 90 8a82e0ba4000 3a841420010000 751f b8???????? }
            // n = 5, score = 200
            //   90                   | nop                 
            //   8a82e0ba4000         | mov                 al, byte ptr [edx + 0x40bae0]
            //   3a841420010000       | cmp                 al, byte ptr [esp + edx + 0x120]
            //   751f                 | jne                 0x21
            //   b8????????           |                     

        $sequence_8 = { 83fe10 7409 33f6 c644241800 eb39 80fb3d 740e }
            // n = 7, score = 200
            //   83fe10               | cmp                 esi, 0x10
            //   7409                 | je                  0xb
            //   33f6                 | xor                 esi, esi
            //   c644241800           | mov                 byte ptr [esp + 0x18], 0
            //   eb39                 | jmp                 0x3b
            //   80fb3d               | cmp                 bl, 0x3d
            //   740e                 | je                  0x10

        $sequence_9 = { 3bd0 72e2 5e 32c0 }
            // n = 4, score = 200
            //   3bd0                 | cmp                 edx, eax
            //   72e2                 | jb                  0xffffffe4
            //   5e                   | pop                 esi
            //   32c0                 | xor                 al, al

    condition:
        7 of them and filesize < 114688
}