rule win_mpkbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mpkbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mpkbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? ff7510 a3???????? }
            // n = 4, score = 400
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   a3????????           |                     

        $sequence_1 = { 68???????? 68???????? 8975f8 8b08 50 }
            // n = 5, score = 400
            //   68????????           |                     
            //   68????????           |                     
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax

        $sequence_2 = { 52 56 6a20 68???????? 68???????? 8975f8 8b08 }
            // n = 7, score = 400
            //   52                   | push                edx
            //   56                   | push                esi
            //   6a20                 | push                0x20
            //   68????????           |                     
            //   68????????           |                     
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_3 = { 50 ff15???????? 8b45fc 3bc6 7406 8b08 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3bc6                 | cmp                 eax, esi
            //   7406                 | je                  8
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_4 = { 68???????? 68???????? 8975f8 8b08 50 ff5150 }
            // n = 6, score = 400
            //   68????????           |                     
            //   68????????           |                     
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5150               | call                dword ptr [ecx + 0x50]

        $sequence_5 = { a5 a5 8b75fc 5f 53 ff15???????? 8bc6 }
            // n = 7, score = 400
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 56 68???????? 68???????? ffd7 6a00 6a01 }
            // n = 6, score = 400
            //   56                   | push                esi
            //   68????????           |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_7 = { eb15 53 ff75f8 56 }
            // n = 4, score = 400
            //   eb15                 | jmp                 0x17
            //   53                   | push                ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi

        $sequence_8 = { d95dd0 d945d0 d9c1 dee1 d95dcc 0fb630 }
            // n = 6, score = 400
            //   d95dd0               | fstp                dword ptr [ebp - 0x30]
            //   d945d0               | fld                 dword ptr [ebp - 0x30]
            //   d9c1                 | fld                 st(1)
            //   dee1                 | fsubrp              st(1)
            //   d95dcc               | fstp                dword ptr [ebp - 0x34]
            //   0fb630               | movzx               esi, byte ptr [eax]

        $sequence_9 = { 6a01 6aff 8975fc 8b08 50 ff5110 85c0 }
            // n = 7, score = 400
            //   6a01                 | push                1
            //   6aff                 | push                -1
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5110               | call                dword ptr [ecx + 0x10]
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 139264
}