rule win_mqsttang_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mqsttang."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mqsttang"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebd4 ebf3 8d4dcc 89c3 e8???????? ebc6 ebe5 }
            // n = 7, score = 100
            //   ebd4                 | jmp                 0xffffffd6
            //   ebf3                 | jmp                 0xfffffff5
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   89c3                 | mov                 ebx, eax
            //   e8????????           |                     
            //   ebc6                 | jmp                 0xffffffc8
            //   ebe5                 | jmp                 0xffffffe7

        $sequence_1 = { f20f105dd8 f20f1065e0 f20f115db8 f20f1165b0 0f87a9000000 890c24 89d9 }
            // n = 7, score = 100
            //   f20f105dd8           | movsd               xmm3, qword ptr [ebp - 0x28]
            //   f20f1065e0           | movsd               xmm4, qword ptr [ebp - 0x20]
            //   f20f115db8           | movsd               qword ptr [ebp - 0x48], xmm3
            //   f20f1165b0           | movsd               qword ptr [ebp - 0x50], xmm4
            //   0f87a9000000         | ja                  0xaf
            //   890c24               | mov                 dword ptr [esp], ecx
            //   89d9                 | mov                 ecx, ebx

        $sequence_2 = { ebec 8b95e4baffff 29ca 83fa02 0f8e87f7ffff 668b4004 6683f83d }
            // n = 7, score = 100
            //   ebec                 | jmp                 0xffffffee
            //   8b95e4baffff         | mov                 edx, dword ptr [ebp - 0x451c]
            //   29ca                 | sub                 edx, ecx
            //   83fa02               | cmp                 edx, 2
            //   0f8e87f7ffff         | jle                 0xfffff78d
            //   668b4004             | mov                 ax, word ptr [eax + 4]
            //   6683f83d             | cmp                 ax, 0x3d

        $sequence_3 = { eb0f f6c220 7413 8365081f 837d0801 7420 43 }
            // n = 7, score = 100
            //   eb0f                 | jmp                 0x11
            //   f6c220               | test                dl, 0x20
            //   7413                 | je                  0x15
            //   8365081f             | and                 dword ptr [ebp + 8], 0x1f
            //   837d0801             | cmp                 dword ptr [ebp + 8], 1
            //   7420                 | je                  0x22
            //   43                   | inc                 ebx

        $sequence_4 = { ff15???????? 891c24 89442404 89c6 c745d402000000 c745d800000000 c745dc00000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   89c6                 | mov                 esi, eax
            //   c745d402000000       | mov                 dword ptr [ebp - 0x2c], 2
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0

        $sequence_5 = { eb16 8b5604 83c301 8b4208 8b4a0c 29c1 39d9 }
            // n = 7, score = 100
            //   eb16                 | jmp                 0x18
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   83c301               | add                 ebx, 1
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   8b4a0c               | mov                 ecx, dword ptr [edx + 0xc]
            //   29c1                 | sub                 ecx, eax
            //   39d9                 | cmp                 ecx, ebx

        $sequence_6 = { f0832a01 742b 8b542420 8b0a 85c9 7451 83f9ff }
            // n = 7, score = 100
            //   f0832a01             | lock sub            dword ptr [edx], 1
            //   742b                 | je                  0x2d
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   85c9                 | test                ecx, ecx
            //   7451                 | je                  0x53
            //   83f9ff               | cmp                 ecx, -1

        $sequence_7 = { f0832801 0f84231b0000 8b4588 8b4010 8b10 85d2 0f84f01a0000 }
            // n = 7, score = 100
            //   f0832801             | lock sub            dword ptr [eax], 1
            //   0f84231b0000         | je                  0x1b29
            //   8b4588               | mov                 eax, dword ptr [ebp - 0x78]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   85d2                 | test                edx, edx
            //   0f84f01a0000         | je                  0x1af6

        $sequence_8 = { c7042400000000 b903000000 ba21000000 89d8 e8???????? 85c0 0f84db000000 }
            // n = 7, score = 100
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   b903000000           | mov                 ecx, 3
            //   ba21000000           | mov                 edx, 0x21
            //   89d8                 | mov                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84db000000         | je                  0xe1

        $sequence_9 = { e8???????? 8985bcfeffff e9???????? 8b4508 8b95fcfeffff 8b4874 8b85f8feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8985bcfeffff         | mov                 dword ptr [ebp - 0x144], eax
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b95fcfeffff         | mov                 edx, dword ptr [ebp - 0x104]
            //   8b4874               | mov                 ecx, dword ptr [eax + 0x74]
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]

    condition:
        7 of them and filesize < 12651520
}