rule win_mrac_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mrac."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mrac"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bc8 e8???????? c78424780600001e000000 c684247c0600006a c684247d0600007f c684247e0600006d }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   c78424780600001e000000     | mov    dword ptr [esp + 0x678], 0x1e
            //   c684247c0600006a     | mov                 byte ptr [esp + 0x67c], 0x6a
            //   c684247d0600007f     | mov                 byte ptr [esp + 0x67d], 0x7f
            //   c684247e0600006d     | mov                 byte ptr [esp + 0x67e], 0x6d

        $sequence_1 = { 8bde 83e03f c1fb06 6bc830 8b049d804b4500 894dfc 837c0118ff }
            // n = 7, score = 200
            //   8bde                 | mov                 ebx, esi
            //   83e03f               | and                 eax, 0x3f
            //   c1fb06               | sar                 ebx, 6
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049d804b4500       | mov                 eax, dword ptr [ebx*4 + 0x454b80]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   837c0118ff           | cmp                 dword ptr [ecx + eax + 0x18], -1

        $sequence_2 = { e8???????? 0420 8d8c2434040000 6a35 8884244f040000 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   0420                 | add                 al, 0x20
            //   8d8c2434040000       | lea                 ecx, [esp + 0x434]
            //   6a35                 | push                0x35
            //   8884244f040000       | mov                 byte ptr [esp + 0x44f], al
            //   e8????????           |                     

        $sequence_3 = { 040f 3476 888424ef040000 8b8424dc040000 0410 3463 888424f0040000 }
            // n = 7, score = 200
            //   040f                 | add                 al, 0xf
            //   3476                 | xor                 al, 0x76
            //   888424ef040000       | mov                 byte ptr [esp + 0x4ef], al
            //   8b8424dc040000       | mov                 eax, dword ptr [esp + 0x4dc]
            //   0410                 | add                 al, 0x10
            //   3463                 | xor                 al, 0x63
            //   888424f0040000       | mov                 byte ptr [esp + 0x4f0], al

        $sequence_4 = { 8b4df0 8b048d804b4500 f644382848 741c 8a55ff 80fa0a 7504 }
            // n = 7, score = 200
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b048d804b4500       | mov                 eax, dword ptr [ecx*4 + 0x454b80]
            //   f644382848           | test                byte ptr [eax + edi + 0x28], 0x48
            //   741c                 | je                  0x1e
            //   8a55ff               | mov                 dl, byte ptr [ebp - 1]
            //   80fa0a               | cmp                 dl, 0xa
            //   7504                 | jne                 6

        $sequence_5 = { e8???????? c68424c813000076 c68424c91300006d c68424ca1300007c 8d8c24c8130000 c68424cb13000028 c68424cc1300007b }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c68424c813000076     | mov                 byte ptr [esp + 0x13c8], 0x76
            //   c68424c91300006d     | mov                 byte ptr [esp + 0x13c9], 0x6d
            //   c68424ca1300007c     | mov                 byte ptr [esp + 0x13ca], 0x7c
            //   8d8c24c8130000       | lea                 ecx, [esp + 0x13c8]
            //   c68424cb13000028     | mov                 byte ptr [esp + 0x13cb], 0x28
            //   c68424cc1300007b     | mov                 byte ptr [esp + 0x13cc], 0x7b

        $sequence_6 = { 8a840d6cffffff 2c0a 88840d6cffffff 41 83f909 72ea 68eeeac01f }
            // n = 7, score = 200
            //   8a840d6cffffff       | mov                 al, byte ptr [ebp + ecx - 0x94]
            //   2c0a                 | sub                 al, 0xa
            //   88840d6cffffff       | mov                 byte ptr [ebp + ecx - 0x94], al
            //   41                   | inc                 ecx
            //   83f909               | cmp                 ecx, 9
            //   72ea                 | jb                  0xffffffec
            //   68eeeac01f           | push                0x1fc0eaee

        $sequence_7 = { 8bf0 c645e57d c645e675 c645e74a c645e86d c645e973 c645ea7e }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   c645e57d             | mov                 byte ptr [ebp - 0x1b], 0x7d
            //   c645e675             | mov                 byte ptr [ebp - 0x1a], 0x75
            //   c645e74a             | mov                 byte ptr [ebp - 0x19], 0x4a
            //   c645e86d             | mov                 byte ptr [ebp - 0x18], 0x6d
            //   c645e973             | mov                 byte ptr [ebp - 0x17], 0x73
            //   c645ea7e             | mov                 byte ptr [ebp - 0x16], 0x7e

        $sequence_8 = { 8d8c2458090000 88842466090000 e8???????? 3453 8d8c2454090000 6a0c 88842467090000 }
            // n = 7, score = 200
            //   8d8c2458090000       | lea                 ecx, [esp + 0x958]
            //   88842466090000       | mov                 byte ptr [esp + 0x966], al
            //   e8????????           |                     
            //   3453                 | xor                 al, 0x53
            //   8d8c2454090000       | lea                 ecx, [esp + 0x954]
            //   6a0c                 | push                0xc
            //   88842467090000       | mov                 byte ptr [esp + 0x967], al

        $sequence_9 = { c68424ce0e000049 c68424cf0e000056 c68424d00e000006 c68424d10e00006b c68424d20e000075 c68424d30e000075 c68424d40e000077 }
            // n = 7, score = 200
            //   c68424ce0e000049     | mov                 byte ptr [esp + 0xece], 0x49
            //   c68424cf0e000056     | mov                 byte ptr [esp + 0xecf], 0x56
            //   c68424d00e000006     | mov                 byte ptr [esp + 0xed0], 6
            //   c68424d10e00006b     | mov                 byte ptr [esp + 0xed1], 0x6b
            //   c68424d20e000075     | mov                 byte ptr [esp + 0xed2], 0x75
            //   c68424d30e000075     | mov                 byte ptr [esp + 0xed3], 0x75
            //   c68424d40e000077     | mov                 byte ptr [esp + 0xed4], 0x77

    condition:
        7 of them and filesize < 745472
}