rule win_mulcom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mulcom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mulcom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? b801000000 488b8d70050000 4833cc e8???????? 4c8d9c2480060000 498b5b28 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   b801000000           | jne                 0xa64
            //   488b8d70050000       | inc                 ecx
            //   4833cc               | dec                 dword ptr [ecx + 0x18]
            //   e8????????           |                     
            //   4c8d9c2480060000     | jne                 0xa8e
            //   498b5b28             | dec                 ecx

        $sequence_1 = { 488d4b27 4883c8ff 483bcb 480f46c8 e8???????? 488bc8 4885c0 }
            // n = 7, score = 100
            //   488d4b27             | mov                 dword ptr [ecx + 0x718], eax
            //   4883c8ff             | dec                 ecx
            //   483bcb               | mov                 eax, dword ptr [esp + 8]
            //   480f46c8             | inc                 esp
            //   e8????????           |                     
            //   488bc8               | mov                 edi, dword ptr [edx + 0x10]
            //   4885c0               | inc                 ecx

        $sequence_2 = { 488d4398 483bc6 75c8 488b5c2430 488b4c2440 482bcb 48b80dc3300cc3300cc3 }
            // n = 7, score = 100
            //   488d4398             | mov                 dword ptr [ebp - 0x58], edi
            //   483bc6               | dec                 eax
            //   75c8                 | mov                 dword ptr [ebp - 0x50], eax
            //   488b5c2430           | inc                 esp
            //   488b4c2440           | mov                 dword ptr [esp + 0x30], esi
            //   482bcb               | dec                 eax
            //   48b80dc3300cc3300cc3     | lea    ecx, [esp + 0x40]

        $sequence_3 = { 0f86cd000000 8bc6 4c8d3440 4c8b7c2438 4c8d4dff }
            // n = 5, score = 100
            //   0f86cd000000         | dec                 eax
            //   8bc6                 | mov                 edi, eax
            //   4c8d3440             | mov                 ecx, 0x1300
            //   4c8b7c2438           | inc                 ecx
            //   4c8d4dff             | mov                 ecx, 0x409

        $sequence_4 = { 488b03 48634804 4803cb 4533c0 8bd7 e8???????? 90 }
            // n = 7, score = 100
            //   488b03               | add                 eax, eax
            //   48634804             | sub                 ecx, eax
            //   4803cb               | je                  0x1cb
            //   4533c0               | dec                 ecx
            //   8bd7                 | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 eax, [0xfffd4781]

        $sequence_5 = { 488d4c2440 e8???????? 488d5530 48837d4810 480f435530 8b5d40 448bc3 }
            // n = 7, score = 100
            //   488d4c2440           | cmp                 eax, 1
            //   e8????????           |                     
            //   488d5530             | jbe                 0x1bd9
            //   48837d4810           | inc                 esp
            //   480f435530           | mov                 eax, edi
            //   8b5d40               | dec                 eax
            //   448bc3               | arpl                bx, dx

        $sequence_6 = { eb73 4c8d442430 ba0e000000 488bcf ff15???????? 85c0 750b }
            // n = 7, score = 100
            //   eb73                 | dec                 eax
            //   4c8d442430           | lea                 ecx, [edx + 0x28]
            //   ba0e000000           | dec                 eax
            //   488bcf               | mov                 dword ptr [esp + 0x10], edx
            //   ff15????????         |                     
            //   85c0                 | push                ebp
            //   750b                 | dec                 eax

        $sequence_7 = { 55 488bec 4883ec70 488b05???????? 4833c4 488945f0 488955d0 }
            // n = 7, score = 100
            //   55                   | mov                 dword ptr [ebp - 0x11], eax
            //   488bec               | inc                 ecx
            //   4883ec70             | mov                 edx, esi
            //   488b05????????       |                     
            //   4833c4               | dec                 eax
            //   488945f0             | lea                 ecx, [ebp - 9]
            //   488955d0             | dec                 eax

        $sequence_8 = { 498b4110 d020 c3 81fa80000000 731e 4183f804 7318 }
            // n = 7, score = 100
            //   498b4110             | jne                 0x8aa
            //   d020                 | dec                 eax
            //   c3                   | mov                 eax, dword ptr [ecx]
            //   81fa80000000         | dec                 eax
            //   731e                 | mov                 edx, esi
            //   4183f804             | call                dword ptr [eax + 8]
            //   7318                 | dec                 eax

        $sequence_9 = { 751f 488b0d???????? 488d1d55e80200 483bcb 740c e8???????? 48891d???????? }
            // n = 7, score = 100
            //   751f                 | pop                 ebp
            //   488b0d????????       |                     
            //   488d1d55e80200       | ret                 
            //   483bcb               | dec                 eax
            //   740c                 | lea                 ecx, [edx + 0x28]
            //   e8????????           |                     
            //   48891d????????       |                     

    condition:
        7 of them and filesize < 867328
}