rule win_murofet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.murofet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.murofet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a2???????? 84c0 7510 e8???????? 3c04 73ce b002 }
            // n = 7, score = 400
            //   a2????????           |                     
            //   84c0                 | test                al, al
            //   7510                 | jne                 0x12
            //   e8????????           |                     
            //   3c04                 | cmp                 al, 4
            //   73ce                 | jae                 0xffffffd0
            //   b002                 | mov                 al, 2

        $sequence_1 = { 72e5 e8???????? a2???????? 84c0 7510 }
            // n = 5, score = 400
            //   72e5                 | jb                  0xffffffe7
            //   e8????????           |                     
            //   a2????????           |                     
            //   84c0                 | test                al, al
            //   7510                 | jne                 0x12

        $sequence_2 = { 3c02 72e5 e8???????? a2???????? 84c0 7510 }
            // n = 6, score = 400
            //   3c02                 | cmp                 al, 2
            //   72e5                 | jb                  0xffffffe7
            //   e8????????           |                     
            //   a2????????           |                     
            //   84c0                 | test                al, al
            //   7510                 | jne                 0x12

        $sequence_3 = { 3c04 73ce b002 a2???????? }
            // n = 4, score = 400
            //   3c04                 | cmp                 al, 4
            //   73ce                 | jae                 0xffffffd0
            //   b002                 | mov                 al, 2
            //   a2????????           |                     

        $sequence_4 = { 57 56 ff15???????? c6443eff00 83f8ff 7509 56 }
            // n = 7, score = 400
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   c6443eff00           | mov                 byte ptr [esi + edi - 1], 0
            //   83f8ff               | cmp                 eax, -1
            //   7509                 | jne                 0xb
            //   56                   | push                esi

        $sequence_5 = { e8???????? 32c0 eb43 be30750000 56 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   32c0                 | xor                 al, al
            //   eb43                 | jmp                 0x45
            //   be30750000           | mov                 esi, 0x7530
            //   56                   | push                esi

        $sequence_6 = { e8???????? a2???????? 84c0 7510 e8???????? }
            // n = 5, score = 400
            //   e8????????           |                     
            //   a2????????           |                     
            //   84c0                 | test                al, al
            //   7510                 | jne                 0x12
            //   e8????????           |                     

        $sequence_7 = { e8???????? 3c04 73ce b002 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   3c04                 | cmp                 al, 4
            //   73ce                 | jae                 0xffffffd0
            //   b002                 | mov                 al, 2

        $sequence_8 = { 84c0 7510 e8???????? 3c04 }
            // n = 4, score = 400
            //   84c0                 | test                al, al
            //   7510                 | jne                 0x12
            //   e8????????           |                     
            //   3c04                 | cmp                 al, 4

        $sequence_9 = { 3c02 72e5 e8???????? a2???????? }
            // n = 4, score = 400
            //   3c02                 | cmp                 al, 2
            //   72e5                 | jb                  0xffffffe7
            //   e8????????           |                     
            //   a2????????           |                     

    condition:
        7 of them and filesize < 622592
}