rule win_mutabaha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mutabaha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mutabaha"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4610 c6040808 ff4610 8b4610 c6040100 e9???????? 8b4610 }
            // n = 7, score = 100
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   c6040808             | mov                 byte ptr [eax + ecx], 8
            //   ff4610               | inc                 dword ptr [esi + 0x10]
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   c6040100             | mov                 byte ptr [ecx + eax], 0
            //   e9????????           |                     
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

        $sequence_1 = { eb18 2bf9 8d145501000000 2bc1 8bcb c1e905 2bd9 }
            // n = 7, score = 100
            //   eb18                 | jmp                 0x1a
            //   2bf9                 | sub                 edi, ecx
            //   8d145501000000       | lea                 edx, [edx*2 + 1]
            //   2bc1                 | sub                 eax, ecx
            //   8bcb                 | mov                 ecx, ebx
            //   c1e905               | shr                 ecx, 5
            //   2bd9                 | sub                 ebx, ecx

        $sequence_2 = { 53 e8???????? 83c41c 85c0 0f8543050000 8b4320 8d55f0 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   85c0                 | test                eax, eax
            //   0f8543050000         | jne                 0x549
            //   8b4320               | mov                 eax, dword ptr [ebx + 0x20]
            //   8d55f0               | lea                 edx, [ebp - 0x10]

        $sequence_3 = { 68???????? ff15???????? 898530fdffff 85c0 0f8441010000 68???????? 8d8d6cfdffff }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   898530fdffff         | mov                 dword ptr [ebp - 0x2d0], eax
            //   85c0                 | test                eax, eax
            //   0f8441010000         | je                  0x147
            //   68????????           |                     
            //   8d8d6cfdffff         | lea                 ecx, [ebp - 0x294]

        $sequence_4 = { 56 8bf1 8d4de8 57 8bfa e8???????? 83781408 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   e8????????           |                     
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8

        $sequence_5 = { 0fafce 3bc1 731b 8bf9 b900080000 2bce c1e905 }
            // n = 7, score = 100
            //   0fafce               | imul                ecx, esi
            //   3bc1                 | cmp                 eax, ecx
            //   731b                 | jae                 0x1d
            //   8bf9                 | mov                 edi, ecx
            //   b900080000           | mov                 ecx, 0x800
            //   2bce                 | sub                 ecx, esi
            //   c1e905               | shr                 ecx, 5

        $sequence_6 = { e8???????? c7465400000000 8bc6 8b4df4 64890d00000000 59 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c7465400000000       | mov                 dword ptr [esi + 0x54], 0
            //   8bc6                 | mov                 eax, esi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi

        $sequence_7 = { c7856cfdffff07000000 66898558fdffff 8b8554fdffff c78568fdffff00000000 83f808 7213 40 }
            // n = 7, score = 100
            //   c7856cfdffff07000000     | mov    dword ptr [ebp - 0x294], 7
            //   66898558fdffff       | mov                 word ptr [ebp - 0x2a8], ax
            //   8b8554fdffff         | mov                 eax, dword ptr [ebp - 0x2ac]
            //   c78568fdffff00000000     | mov    dword ptr [ebp - 0x298], 0
            //   83f808               | cmp                 eax, 8
            //   7213                 | jb                  0x15
            //   40                   | inc                 eax

        $sequence_8 = { 8bf9 c745f82e000000 e8???????? 40 8bcf 50 8d45f8 }
            // n = 7, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   c745f82e000000       | mov                 dword ptr [ebp - 8], 0x2e
            //   e8????????           |                     
            //   40                   | inc                 eax
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_9 = { 8b8d40efffff 85c9 7414 8b11 8d851cefffff 3bc8 0f95c0 }
            // n = 7, score = 100
            //   8b8d40efffff         | mov                 ecx, dword ptr [ebp - 0x10c0]
            //   85c9                 | test                ecx, ecx
            //   7414                 | je                  0x16
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8d851cefffff         | lea                 eax, [ebp - 0x10e4]
            //   3bc8                 | cmp                 ecx, eax
            //   0f95c0               | setne               al

    condition:
        7 of them and filesize < 1220608
}