rule win_mydogs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mydogs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mydogs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88040a 8d4901 84c0 75f4 6808020000 e8???????? }
            // n = 6, score = 200
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   84c0                 | test                al, al
            //   75f4                 | jne                 0xfffffff6
            //   6808020000           | push                0x208
            //   e8????????           |                     

        $sequence_1 = { 2bca 51 8d85e8fcffff 50 6a01 6a00 53 }
            // n = 7, score = 200
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx
            //   8d85e8fcffff         | lea                 eax, [ebp - 0x318]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_2 = { 50 8b8544f8ffff 33c9 038d48f8ffff 83d000 50 0fb78582f9ffff }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b8544f8ffff         | mov                 eax, dword ptr [ebp - 0x7bc]
            //   33c9                 | xor                 ecx, ecx
            //   038d48f8ffff         | add                 ecx, dword ptr [ebp - 0x7b8]
            //   83d000               | adc                 eax, 0
            //   50                   | push                eax
            //   0fb78582f9ffff       | movzx               eax, word ptr [ebp - 0x67e]

        $sequence_3 = { 83fe20 750f 57 6a01 6a01 68???????? e9???????? }
            // n = 7, score = 200
            //   83fe20               | cmp                 esi, 0x20
            //   750f                 | jne                 0x11
            //   57                   | push                edi
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   68????????           |                     
            //   e9????????           |                     

        $sequence_4 = { 61 9d a1???????? f30f7e05???????? }
            // n = 4, score = 200
            //   61                   | popal               
            //   9d                   | popfd               
            //   a1????????           |                     
            //   f30f7e05????????     |                     

        $sequence_5 = { 33d2 8945d8 b901000000 8930 }
            // n = 4, score = 200
            //   33d2                 | xor                 edx, edx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   b901000000           | mov                 ecx, 1
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_6 = { e8???????? 0fb64608 88450b 6a01 8d450b 50 8bcf }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0fb64608             | movzx               eax, byte ptr [esi + 8]
            //   88450b               | mov                 byte ptr [ebp + 0xb], al
            //   6a01                 | push                1
            //   8d450b               | lea                 eax, [ebp + 0xb]
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi

        $sequence_7 = { 6860ea0000 ff15???????? 68???????? 6a00 68???????? 68???????? }
            // n = 6, score = 200
            //   6860ea0000           | push                0xea60
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     

        $sequence_8 = { 69c005840808 40 894704 898560fbffff c1e818 33c6 25ff000000 }
            // n = 7, score = 200
            //   69c005840808         | imul                eax, eax, 0x8088405
            //   40                   | inc                 eax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   898560fbffff         | mov                 dword ptr [ebp - 0x4a0], eax
            //   c1e818               | shr                 eax, 0x18
            //   33c6                 | xor                 eax, esi
            //   25ff000000           | and                 eax, 0xff

        $sequence_9 = { c785f0eeffff00000000 e8???????? 8bf8 83c408 85ff }
            // n = 5, score = 200
            //   c785f0eeffff00000000     | mov    dword ptr [ebp - 0x1110], 0
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 313344
}