rule win_mylobot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mylobot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mylobot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f6 5e c3 8b442404 eb05 40 84c9 }
            // n = 7, score = 1000
            //   75f6                 | jne                 0xfffffff8
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   eb05                 | jmp                 7
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl

        $sequence_1 = { 6a00 6a00 8d8c24c4000000 51 }
            // n = 4, score = 1000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d8c24c4000000       | lea                 ecx, [esp + 0xc4]
            //   51                   | push                ecx

        $sequence_2 = { 8b54241c 891481 ff430c 8b4ff0 85c9 7502 }
            // n = 6, score = 1000
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   891481               | mov                 dword ptr [ecx + eax*4], edx
            //   ff430c               | inc                 dword ptr [ebx + 0xc]
            //   8b4ff0               | mov                 ecx, dword ptr [edi - 0x10]
            //   85c9                 | test                ecx, ecx
            //   7502                 | jne                 4

        $sequence_3 = { 8bf0 6aff 56 ff15???????? 56 ff15???????? 6810270000 }
            // n = 7, score = 1000
            //   8bf0                 | mov                 esi, eax
            //   6aff                 | push                -1
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6810270000           | push                0x2710

        $sequence_4 = { 5d 5e 5b 81c404080000 c3 8b4c2404 8b54240c }
            // n = 7, score = 1000
            //   5d                   | pop                 ebp
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   81c404080000         | add                 esp, 0x804
            //   c3                   | ret                 
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]

        $sequence_5 = { 42 84c9 75f6 5e c3 }
            // n = 5, score = 1000
            //   42                   | inc                 edx
            //   84c9                 | test                cl, cl
            //   75f6                 | jne                 0xfffffff8
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_6 = { ff96a8000000 50 ff5670 a1???????? 57 ff742410 ff742414 }
            // n = 7, score = 1000
            //   ff96a8000000         | call                dword ptr [esi + 0xa8]
            //   50                   | push                eax
            //   ff5670               | call                dword ptr [esi + 0x70]
            //   a1????????           |                     
            //   57                   | push                edi
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742414             | push                dword ptr [esp + 0x14]

        $sequence_7 = { 8b54240c 56 8b74240c 57 8bf9 2bf1 8bc2 }
            // n = 7, score = 1000
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   56                   | push                esi
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   2bf1                 | sub                 esi, ecx
            //   8bc2                 | mov                 eax, edx

        $sequence_8 = { ff15???????? 85c0 0f8447010000 8b742438 85f6 0f843b010000 8b3d???????? }
            // n = 7, score = 800
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8447010000         | je                  0x14d
            //   8b742438             | mov                 esi, dword ptr [esp + 0x38]
            //   85f6                 | test                esi, esi
            //   0f843b010000         | je                  0x141
            //   8b3d????????         |                     

        $sequence_9 = { 51 8d8ddcfdffff e8???????? 83c404 85c0 }
            // n = 5, score = 800
            //   51                   | push                ecx
            //   8d8ddcfdffff         | lea                 ecx, [ebp - 0x224]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_10 = { c3 ff15???????? 8b45f0 50 ff15???????? }
            // n = 5, score = 800
            //   c3                   | ret                 
            //   ff15????????         |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_11 = { b8???????? e8???????? 83c40c 85c0 0f84d9010000 }
            // n = 5, score = 800
            //   b8????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f84d9010000         | je                  0x1df

        $sequence_12 = { 8d4dfc 51 52 ffd0 8b45fc }
            // n = 5, score = 800
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ffd0                 | call                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_13 = { 6a09 50 ffd2 8bf8 }
            // n = 4, score = 800
            //   6a09                 | push                9
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8bf8                 | mov                 edi, eax

        $sequence_14 = { 7416 8bff 0fb6d0 8a9c15dcfdffff 84db }
            // n = 5, score = 800
            //   7416                 | je                  0x18
            //   8bff                 | mov                 edi, edi
            //   0fb6d0               | movzx               edx, al
            //   8a9c15dcfdffff       | mov                 bl, byte ptr [ebp + edx - 0x224]
            //   84db                 | test                bl, bl

        $sequence_15 = { 85c0 0f84c3000000 8b08 8d55f8 52 68???????? }
            // n = 6, score = 800
            //   85c0                 | test                eax, eax
            //   0f84c3000000         | je                  0xc9
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   68????????           |                     

    condition:
        7 of them and filesize < 8028160
}