rule win_nabucur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nabucur."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nabucur"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 894500 85c0 7fee }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   894500               | mov                 dword ptr [ebp], eax
            //   85c0                 | test                eax, eax
            //   7fee                 | jg                  0xfffffff0

        $sequence_1 = { 48 8944241c 85c0 7fd1 }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   85c0                 | test                eax, eax
            //   7fd1                 | jg                  0xffffffd3

        $sequence_2 = { 48 83f801 89442418 0f8f15ffffff }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   83f801               | cmp                 eax, 1
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   0f8f15ffffff         | jg                  0xffffff1b

        $sequence_3 = { 48 83e908 85c0 75f0 57 }
            // n = 5, score = 200
            //   48                   | dec                 eax
            //   83e908               | sub                 ecx, 8
            //   85c0                 | test                eax, eax
            //   75f0                 | jne                 0xfffffff2
            //   57                   | push                edi

        $sequence_4 = { 48 8906 8d442410 50 }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   8906                 | mov                 dword ptr [esi], eax
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax

        $sequence_5 = { 009eaa030000 0fb686aa030000 57 83f80a 0f876d010000 }
            // n = 5, score = 200
            //   009eaa030000         | add                 byte ptr [esi + 0x3aa], bl
            //   0fb686aa030000       | movzx               eax, byte ptr [esi + 0x3aa]
            //   57                   | push                edi
            //   83f80a               | cmp                 eax, 0xa
            //   0f876d010000         | ja                  0x173

        $sequence_6 = { 33ff 397c242c 7e61 8b6c242c 8b03 8d4c0001 81f900020000 }
            // n = 7, score = 200
            //   33ff                 | xor                 edi, edi
            //   397c242c             | cmp                 dword ptr [esp + 0x2c], edi
            //   7e61                 | jle                 0x63
            //   8b6c242c             | mov                 ebp, dword ptr [esp + 0x2c]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8d4c0001             | lea                 ecx, [eax + eax + 1]
            //   81f900020000         | cmp                 ecx, 0x200

        $sequence_7 = { 48 89442414 85c0 0f8f68ffffff }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   85c0                 | test                eax, eax
            //   0f8f68ffffff         | jg                  0xffffff6e

        $sequence_8 = { 89728e 5f 5c ab }
            // n = 4, score = 100
            //   89728e               | mov                 dword ptr [edx - 0x72], esi
            //   5f                   | pop                 edi
            //   5c                   | pop                 esp
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_9 = { e9???????? ffd6 e9???????? 5e e9???????? 68ad009a0c }
            // n = 6, score = 100
            //   e9????????           |                     
            //   ffd6                 | call                esi
            //   e9????????           |                     
            //   5e                   | pop                 esi
            //   e9????????           |                     
            //   68ad009a0c           | push                0xc9a00ad

        $sequence_10 = { ba0eb4d3fc 83c604 eb0c 83f901 }
            // n = 4, score = 100
            //   ba0eb4d3fc           | mov                 edx, 0xfcd3b40e
            //   83c604               | add                 esi, 4
            //   eb0c                 | jmp                 0xe
            //   83f901               | cmp                 ecx, 1

        $sequence_11 = { 8bec 68???????? e8???????? 813d????????1d932600 }
            // n = 4, score = 100
            //   8bec                 | mov                 ebp, esp
            //   68????????           |                     
            //   e8????????           |                     
            //   813d????????1d932600     |     

        $sequence_12 = { e022 0884df221d84c2 221b 84dd 223c84 }
            // n = 5, score = 100
            //   e022                 | loopne              0x24
            //   0884df221d84c2       | or                  byte ptr [edi + ebx*8 - 0x3d7be2de], al
            //   221b                 | and                 bl, byte ptr [ebx]
            //   84dd                 | test                ch, bl
            //   223c84               | and                 bh, byte ptr [esp + eax*4]

        $sequence_13 = { b4d6 98 db3e d35f9e c25a1a }
            // n = 5, score = 100
            //   b4d6                 | mov                 ah, 0xd6
            //   98                   | cwde                
            //   db3e                 | fstp                xword ptr [esi]
            //   d35f9e               | rcr                 dword ptr [edi - 0x62], cl
            //   c25a1a               | ret                 0x1a5a

        $sequence_14 = { af 6abb 8ed5 3155fc }
            // n = 4, score = 100
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   6abb                 | push                -0x45
            //   8ed5                 | mov                 ss, ebp
            //   3155fc               | xor                 dword ptr [ebp - 4], edx

        $sequence_15 = { 91 039109861780 60 96 }
            // n = 4, score = 100
            //   91                   | xchg                eax, ecx
            //   039109861780         | add                 edx, dword ptr [ecx - 0x7fe879f7]
            //   60                   | pushal              
            //   96                   | xchg                eax, esi

    condition:
        7 of them and filesize < 1949696
}