rule win_naikon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.naikon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.naikon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 59 3bfb 59 741d 8b06 2bc7 }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx
            //   3bfb                 | cmp                 edi, ebx
            //   59                   | pop                 ecx
            //   741d                 | je                  0x1f
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   2bc7                 | sub                 eax, edi

        $sequence_1 = { eb05 397df8 7415 8d45f0 }
            // n = 4, score = 200
            //   eb05                 | jmp                 7
            //   397df8               | cmp                 dword ptr [ebp - 8], edi
            //   7415                 | je                  0x17
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_2 = { 8975c4 8945b0 8b450c 8945bc 03f0 8b45e4 8b4f6c }
            // n = 7, score = 200
            //   8975c4               | mov                 dword ptr [ebp - 0x3c], esi
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   03f0                 | add                 esi, eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b4f6c               | mov                 ecx, dword ptr [edi + 0x6c]

        $sequence_3 = { 53 50 e8???????? 6a04 8d85f8fdffff 68???????? 50 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a04                 | push                4
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_4 = { 8b06 03c3 68???????? 50 e8???????? 68???????? e9???????? }
            // n = 7, score = 200
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   03c3                 | add                 eax, ebx
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   68????????           |                     
            //   e9????????           |                     

        $sequence_5 = { 03c8 83c00c 8903 8d45d8 6a0c 50 ff750c }
            // n = 7, score = 200
            //   03c8                 | add                 ecx, eax
            //   83c00c               | add                 eax, 0xc
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   6a0c                 | push                0xc
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_6 = { e8???????? ff75fc e8???????? 83c414 eb02 33db }
            // n = 6, score = 200
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx

        $sequence_7 = { 6a10 68???????? e9???????? 6a00 ff75fc 53 8d853cffffff }
            // n = 7, score = 200
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   e9????????           |                     
            //   6a00                 | push                0
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   53                   | push                ebx
            //   8d853cffffff         | lea                 eax, [ebp - 0xc4]

        $sequence_8 = { 8b00 52 53 53 8b4010 }
            // n = 5, score = 200
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   52                   | push                edx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]

        $sequence_9 = { 838e90000000ff 8dbe8c000000 85c0 740a 50 ff15???????? }
            // n = 6, score = 200
            //   838e90000000ff       | or                  dword ptr [esi + 0x90], 0xffffffff
            //   8dbe8c000000         | lea                 edi, [esi + 0x8c]
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 188416
}