rule win_nailao_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nailao_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nailao_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 4c8d4c2474 488bcb 4c8d44246c 488d542464 ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4c8d4c2474           | inc                 ecx
            //   488bcb               | mov                 ecx, esi
            //   4c8d44246c           | nop                 word ptr [eax + eax]
            //   488d542464           | movdqu              xmm0, xmmword ptr [eax - 0x10]
            //   ff15????????         |                     

        $sequence_1 = { 488bc5 4c8d0551650100 488bcd 48c1f906 83e03f 498b0cc8 488d14c0 }
            // n = 7, score = 100
            //   488bc5               | nop                 word ptr [eax + eax]
            //   4c8d0551650100       | dec                 eax
            //   488bcd               | mov                 eax, dword ptr [esp + 0x60]
            //   48c1f906             | test                eax, 0x11600
            //   83e03f               | jne                 0x4e3
            //   498b0cc8             | dec                 eax
            //   488d14c0             | lea                 ecx, [ebp - 0x74]

        $sequence_2 = { 488bd8 4885c0 7560 488bc7 4c8d35104cffff 498784f620120200 }
            // n = 6, score = 100
            //   488bd8               | dec                 ebp
            //   4885c0               | mov                 ebx, ecx
            //   7560                 | dec                 ecx
            //   488bc7               | shr                 ebx, 4
            //   4c8d35104cffff       | inc                 edi
            //   498784f620120200     | mov                 ebx, dword ptr [edx + ebx*4 + 0x19f88]

        $sequence_3 = { e8???????? 4c8d458c 488bd7 85c0 7411 448bc8 488d0ddd7a0100 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d458c             | test                eax, eax
            //   488bd7               | dec                 eax
            //   85c0                 | sub                 esp, 0x20
            //   7411                 | dec                 eax
            //   448bc8               | mov                 ebx, ecx
            //   488d0ddd7a0100       | dec                 eax

        $sequence_4 = { 48c744242000000000 488bce ff15???????? 85c0 741d 41ffc6 }
            // n = 6, score = 100
            //   48c744242000000000     | xorps    xmm1, xmm0
            //   488bce               | movdqu              xmmword ptr [eax - 0x20], xmm1
            //   ff15????????         |                     
            //   85c0                 | cmp                 ecx, 0x100
            //   741d                 | jb                  0x85
            //   41ffc6               | mov                 dword ptr [esp + 0x48], 2

        $sequence_5 = { c705????????01000000 b808000000 486bc000 488d0d19d80100 8b542430 48891401 }
            // n = 6, score = 100
            //   c705????????01000000     |     
            //   b808000000           | dec                 eax
            //   486bc000             | lea                 edx, [0x188dc]
            //   488d0d19d80100       | dec                 esp
            //   8b542430             | mov                 eax, dword ptr [esp + 0x860]
            //   48891401             | dec                 esp

        $sequence_6 = { 488d0ddd7a0100 e8???????? eb58 488d0d1f7b0100 eb47 488d1596790100 488bcb }
            // n = 7, score = 100
            //   488d0ddd7a0100       | mov                 dword ptr [ecx], eax
            //   e8????????           |                     
            //   eb58                 | ret                 
            //   488d0d1f7b0100       | dec                 eax
            //   eb47                 | and                 dword ptr [ecx + 0x10], 0
            //   488d1596790100       | dec                 eax
            //   488bcb               | lea                 eax, [0xf598]

        $sequence_7 = { e8???????? 488d156f870100 488d4c2420 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   488d156f870100       | dec                 eax
            //   488d4c2420           | lea                 ecx, [0x13078]
            //   e8????????           |                     

        $sequence_8 = { ff15???????? 85c0 750d 4c8d442450 488bd7 e8???????? 83eb01 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   750d                 | mov                 edx, edi
            //   4c8d442450           | test                eax, eax
            //   488bd7               | je                  0x64f
            //   e8????????           |                     
            //   83eb01               | inc                 esp

        $sequence_9 = { 488985d0070000 49895b20 488bfa 498973e8 4d896bd8 4d8be8 }
            // n = 6, score = 100
            //   488985d0070000       | dec                 eax
            //   49895b20             | mov                 eax, ecx
            //   488bfa               | dec                 eax
            //   498973e8             | sar                 eax, 6
            //   4d896bd8             | dec                 esp
            //   4d8be8               | lea                 ecx, [0x11594]

    condition:
        7 of them and filesize < 512000
}