rule win_nautilus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nautilus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nautilus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? eb0b 0f28ce 488bcb e8???????? 660f2efe 7a02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb0b                 | test                eax, eax
            //   0f28ce               | jne                 0x481
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   660f2efe             | mov                 ecx, edi
            //   7a02                 | dec                 eax

        $sequence_1 = { e8???????? 410fb7445c0a 498bce 0fb61406 448b0487 e8???????? 410fb7445c0c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   410fb7445c0a         | mov                 ecx, dword ptr [edi + 0x2f0]
            //   498bce               | dec                 eax
            //   0fb61406             | mov                 ecx, dword ptr [edi + 0x80]
            //   448b0487             | xor                 edx, edx
            //   e8????????           |                     
            //   410fb7445c0c         | dec                 eax

        $sequence_2 = { e9???????? 413bfc 0f84c7000000 41be20000000 eb09 413bfc 0f84b6000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   413bfc               | dec                 eax
            //   0f84c7000000         | lea                 edx, [ebp + 0x40]
            //   41be20000000         | inc                 ecx
            //   eb09                 | mov                 eax, 4
            //   413bfc               | dec                 eax
            //   0f84b6000000         | mov                 ecx, edi

        $sequence_3 = { f20f5ccd eb08 f20f59ce f20f58ce 4885d2 7407 0f570d???????? }
            // n = 7, score = 100
            //   f20f5ccd             | dec                 eax
            //   eb08                 | lea                 eax, [0x5d842]
            //   f20f59ce             | dec                 eax
            //   f20f58ce             | mov                 dword ptr [ebp - 0x30], eax
            //   4885d2               | dec                 eax
            //   7407                 | lea                 eax, [0x5d83b]
            //   0f570d????????       |                     

        $sequence_4 = { eb19 443bc3 7f14 c1e917 4103c8 3bd9 7f0a }
            // n = 7, score = 100
            //   eb19                 | inc                 esp
            //   443bc3               | mov                 eax, dword ptr [esp + 0x60]
            //   7f14                 | dec                 eax
            //   c1e917               | mov                 edx, edi
            //   4103c8               | dec                 eax
            //   3bd9                 | mov                 ecx, ebx
            //   7f0a                 | dec                 eax

        $sequence_5 = { 85c0 751b 488d4b18 8d5001 e8???????? 85c0 750b }
            // n = 7, score = 100
            //   85c0                 | lea                 edx, [ebp - 0x61]
            //   751b                 | movsd               qword ptr [ebp - 0x59], xmm2
            //   488d4b18             | movsd               qword ptr [ebp - 0x61], xmm3
            //   8d5001               | movaps              xmm6, xmm2
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   750b                 | mov                 dword ptr [ebp + 0x20], eax

        $sequence_6 = { 7459 41ffca 740a b800bfffff 4883c458 c3 488b842498000000 }
            // n = 7, score = 100
            //   7459                 | mov                 dl, byte ptr [ecx + eax]
            //   41ffca               | inc                 esi
            //   740a                 | mov                 dl, byte ptr [ecx + eax]
            //   b800bfffff           | inc                 esi
            //   4883c458             | mov                 bl, byte ptr [edx + eax]
            //   c3                   | inc                 ebp
            //   488b842498000000     | cmp                 dl, bl

        $sequence_7 = { 7520 488d7eff 488d55b0 488d4dc8 4885ff 756b e8???????? }
            // n = 7, score = 100
            //   7520                 | mov                 eax, ecx
            //   488d7eff             | dec                 eax
            //   488d55b0             | sub                 eax, edx
            //   488d4dc8             | dec                 eax
            //   4885ff               | cmp                 eax, ebx
            //   756b                 | jb                  0x941
            //   e8????????           |                     

        $sequence_8 = { 83f815 0f842b010000 83f816 74ba 83f817 745e 7e3c }
            // n = 7, score = 100
            //   83f815               | jg                  0x61
            //   0f842b010000         | dec                 esp
            //   83f816               | lea                 ecx, [esp + 0x20]
            //   74ba                 | dec                 eax
            //   83f817               | lea                 ecx, [edi + 0x28]
            //   745e                 | dec                 esp
            //   7e3c                 | mov                 eax, edi

        $sequence_9 = { 7424 bafeffff7f 33c9 e8???????? 8bcb 8bd0 488b4730 }
            // n = 7, score = 100
            //   7424                 | mov                 byte ptr [edi + 4], cl
            //   bafeffff7f           | shr                 eax, 8
            //   33c9                 | inc                 ecx
            //   e8????????           |                     
            //   8bcb                 | mov                 byte ptr [edi + 8], dl
            //   8bd0                 | inc                 ecx
            //   488b4730             | mov                 byte ptr [edi + 0xc], cl

    condition:
        7 of them and filesize < 1302528
}