rule win_ncctrojan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ncctrojan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ncctrojan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f805 7536 8b85e8feffff 85c0 750a }
            // n = 5, score = 500
            //   83f805               | cmp                 eax, 5
            //   7536                 | jne                 0x38
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc

        $sequence_1 = { 68???????? e9???????? 83f801 750a 68???????? }
            // n = 5, score = 500
            //   68????????           |                     
            //   e9????????           |                     
            //   83f801               | cmp                 eax, 1
            //   750a                 | jne                 0xc
            //   68????????           |                     

        $sequence_2 = { 750a 68???????? e9???????? 83f802 }
            // n = 4, score = 500
            //   750a                 | jne                 0xc
            //   68????????           |                     
            //   e9????????           |                     
            //   83f802               | cmp                 eax, 2

        $sequence_3 = { d1f9 8d4101 50 e8???????? 8b542410 83c404 8bca }
            // n = 7, score = 400
            //   d1f9                 | sar                 ecx, 1
            //   8d4101               | lea                 eax, [ecx + 1]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   83c404               | add                 esp, 4
            //   8bca                 | mov                 ecx, edx

        $sequence_4 = { 50 e8???????? 8d45f4 50 8d85e8adffff }
            // n = 5, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d85e8adffff         | lea                 eax, [ebp - 0x5218]

        $sequence_5 = { c785ccbdffff00000000 668985dcbdffff 8d85ecfdffff 8985d4bdffff }
            // n = 4, score = 400
            //   c785ccbdffff00000000     | mov    dword ptr [ebp - 0x4234], 0
            //   668985dcbdffff       | mov                 word ptr [ebp - 0x4224], ax
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   8985d4bdffff         | mov                 dword ptr [ebp - 0x422c], eax

        $sequence_6 = { 85d2 0f8407010000 83faff 0f84fe000000 33c0 85d2 }
            // n = 6, score = 400
            //   85d2                 | test                edx, edx
            //   0f8407010000         | je                  0x10d
            //   83faff               | cmp                 edx, -1
            //   0f84fe000000         | je                  0x104
            //   33c0                 | xor                 eax, eax
            //   85d2                 | test                edx, edx

        $sequence_7 = { e8???????? 68???????? 6a20 68???????? e8???????? 83c418 e8???????? }
            // n = 7, score = 400
            //   e8????????           |                     
            //   68????????           |                     
            //   6a20                 | push                0x20
            //   68????????           |                     
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   e8????????           |                     

        $sequence_8 = { 0f99c0 8d044501000000 5e 5d c3 3b0d???????? }
            // n = 6, score = 300
            //   0f99c0               | setns               al
            //   8d044501000000       | lea                 eax, [eax*2 + 1]
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   3b0d????????         |                     

        $sequence_9 = { 03c1 50 51 ff7304 }
            // n = 4, score = 300
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff7304               | push                dword ptr [ebx + 4]

        $sequence_10 = { 837dec08 8d45d8 0f4345d8 83ec18 }
            // n = 4, score = 300
            //   837dec08             | cmp                 dword ptr [ebp - 0x14], 8
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   0f4345d8             | cmovae              eax, dword ptr [ebp - 0x28]
            //   83ec18               | sub                 esp, 0x18

        $sequence_11 = { 8965f0 6a01 8945ec 40 6a00 }
            // n = 5, score = 300
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   6a01                 | push                1
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   40                   | inc                 eax
            //   6a00                 | push                0

        $sequence_12 = { 7e6f 8945c8 8b400c 8b7004 }
            // n = 4, score = 300
            //   7e6f                 | jle                 0x71
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b7004               | mov                 esi, dword ptr [eax + 4]

        $sequence_13 = { 0f437d08 ff15???????? 50 56 }
            // n = 4, score = 300
            //   0f437d08             | cmovae              edi, dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_14 = { 50 51 8d4d08 e8???????? 56 8985c8feffff 8d4d08 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   56                   | push                esi
            //   8985c8feffff         | mov                 dword ptr [ebp - 0x138], eax
            //   8d4d08               | lea                 ecx, [ebp + 8]

        $sequence_15 = { 02c9 2480 7403 80f11b 83ea01 }
            // n = 5, score = 300
            //   02c9                 | add                 cl, cl
            //   2480                 | and                 al, 0x80
            //   7403                 | je                  5
            //   80f11b               | xor                 cl, 0x1b
            //   83ea01               | sub                 edx, 1

    condition:
        7 of them and filesize < 1160192
}