rule win_nefilim_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nefilim."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nefilim"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 ff15???????? 50 ff15???????? 57 8bf0 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 7304 8d442414 68???????? 50 ffd6 85c0 0f84dc000000 }
            // n = 7, score = 200
            //   7304                 | jae                 6
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84dc000000         | je                  0xe2

        $sequence_2 = { 50 ffd6 85c0 0f849b040000 68???????? 8d8424d0000000 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f849b040000         | je                  0x4a1
            //   68????????           |                     
            //   8d8424d0000000       | lea                 eax, [esp + 0xd0]

        $sequence_3 = { 0f8f5d010000 8b4c2418 394c2428 0f822dffffff e9???????? }
            // n = 5, score = 200
            //   0f8f5d010000         | jg                  0x163
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   394c2428             | cmp                 dword ptr [esp + 0x28], ecx
            //   0f822dffffff         | jb                  0xffffff33
            //   e9????????           |                     

        $sequence_4 = { 3b5d0c 72b3 5e 8b8538ffffff 6a10 2bf8 }
            // n = 6, score = 200
            //   3b5d0c               | cmp                 ebx, dword ptr [ebp + 0xc]
            //   72b3                 | jb                  0xffffffb5
            //   5e                   | pop                 esi
            //   8b8538ffffff         | mov                 eax, dword ptr [ebp - 0xc8]
            //   6a10                 | push                0x10
            //   2bf8                 | sub                 edi, eax

        $sequence_5 = { 33c0 50 50 ff74241c ffd7 53 8d442434 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ffd7                 | call                edi
            //   53                   | push                ebx
            //   8d442434             | lea                 eax, [esp + 0x34]

        $sequence_6 = { 8bf0 ffd3 50 57 e8???????? }
            // n = 5, score = 200
            //   8bf0                 | mov                 esi, eax
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_7 = { 68???????? 50 ffd6 85c0 0f84a0000000 8b442414 397c2428 }
            // n = 7, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84a0000000         | je                  0xa6
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   397c2428             | cmp                 dword ptr [esp + 0x28], edi

        $sequence_8 = { 8b4de0 a3???????? 7303 8d4de0 }
            // n = 4, score = 200
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   a3????????           |                     
            //   7303                 | jae                 5
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_9 = { c9 c3 55 8bec 83e4f8 81ecec020000 a1???????? }
            // n = 7, score = 200
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83e4f8               | and                 esp, 0xfffffff8
            //   81ecec020000         | sub                 esp, 0x2ec
            //   a1????????           |                     

    condition:
        7 of them and filesize < 142336
}