rule win_nemim_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nemim."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nemim"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c002 53 55 56 57 8d742410 bf10000000 }
            // n = 7, score = 200
            //   83c002               | add                 eax, 2
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d742410             | lea                 esi, [esp + 0x10]
            //   bf10000000           | mov                 edi, 0x10

        $sequence_1 = { 52 6801000080 ff15???????? 8d442418 8d4c2454 50 8b442418 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   8d4c2454             | lea                 ecx, [esp + 0x54]
            //   50                   | push                eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_2 = { 56 ff15???????? 8b442410 3d97010000 0f84ae000000 6800040000 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   3d97010000           | cmp                 eax, 0x197
            //   0f84ae000000         | je                  0xb4
            //   6800040000           | push                0x400

        $sequence_3 = { 888424e7000000 e8???????? 83c404 8d9424b4000000 68???????? 6819000200 6a00 }
            // n = 7, score = 200
            //   888424e7000000       | mov                 byte ptr [esp + 0xe7], al
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d9424b4000000       | lea                 edx, [esp + 0xb4]
            //   68????????           |                     
            //   6819000200           | push                0x20019
            //   6a00                 | push                0

        $sequence_4 = { 8bd1 8dbc2450020000 c1e902 f3ab 8bca }
            // n = 5, score = 200
            //   8bd1                 | mov                 edx, ecx
            //   8dbc2450020000       | lea                 edi, [esp + 0x250]
            //   c1e902               | shr                 ecx, 2
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bca                 | mov                 ecx, edx

        $sequence_5 = { 52 e8???????? 8d442458 50 e8???????? 8b15???????? 8d4c245c }
            // n = 7, score = 200
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d442458             | lea                 eax, [esp + 0x58]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b15????????         |                     
            //   8d4c245c             | lea                 ecx, [esp + 0x5c]

        $sequence_6 = { 8b6c2440 8dbc3839d0d4d9 8bc7 c1e81c c1e704 0bc7 8bfe }
            // n = 7, score = 200
            //   8b6c2440             | mov                 ebp, dword ptr [esp + 0x40]
            //   8dbc3839d0d4d9       | lea                 edi, [eax + edi - 0x262b2fc7]
            //   8bc7                 | mov                 eax, edi
            //   c1e81c               | shr                 eax, 0x1c
            //   c1e704               | shl                 edi, 4
            //   0bc7                 | or                  eax, edi
            //   8bfe                 | mov                 edi, esi

        $sequence_7 = { 8bf0 750b c1e602 8b8628274300 eb09 c1e602 }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   750b                 | jne                 0xd
            //   c1e602               | shl                 esi, 2
            //   8b8628274300         | mov                 eax, dword ptr [esi + 0x432728]
            //   eb09                 | jmp                 0xb
            //   c1e602               | shl                 esi, 2

        $sequence_8 = { 83fe10 7cde c605????????00 b90b000000 be???????? 8dbc2410010000 }
            // n = 6, score = 200
            //   83fe10               | cmp                 esi, 0x10
            //   7cde                 | jl                  0xffffffe0
            //   c605????????00       |                     
            //   b90b000000           | mov                 ecx, 0xb
            //   be????????           |                     
            //   8dbc2410010000       | lea                 edi, [esp + 0x110]

        $sequence_9 = { 68e8030000 e8???????? 83c404 85f6 }
            // n = 4, score = 200
            //   68e8030000           | push                0x3e8
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi

    condition:
        7 of them and filesize < 499712
}