rule win_nestegg_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nestegg."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nestegg"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c2420 33ed 89442444 51 }
            // n = 4, score = 200
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   33ed                 | xor                 ebp, ebp
            //   89442444             | mov                 dword ptr [esp + 0x44], eax
            //   51                   | push                ecx

        $sequence_1 = { 6a08 ff15???????? 8be8 b988000000 33c0 8dbc24a8020000 c78424a402000024020000 }
            // n = 7, score = 200
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   b988000000           | mov                 ecx, 0x88
            //   33c0                 | xor                 eax, eax
            //   8dbc24a8020000       | lea                 edi, [esp + 0x2a8]
            //   c78424a402000024020000     | mov    dword ptr [esp + 0x2a4], 0x224

        $sequence_2 = { 89742410 e8???????? 6a00 6800200000 8d8e2c040000 c744245800000000 }
            // n = 6, score = 200
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6800200000           | push                0x2000
            //   8d8e2c040000         | lea                 ecx, [esi + 0x42c]
            //   c744245800000000     | mov                 dword ptr [esp + 0x58], 0

        $sequence_3 = { 2bc3 8bce 50 e8???????? 8b8f28040000 }
            // n = 5, score = 200
            //   2bc3                 | sub                 eax, ebx
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8f28040000         | mov                 ecx, dword ptr [edi + 0x428]

        $sequence_4 = { 5f 5e 59 c20c00 ff15???????? }
            // n = 5, score = 200
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   59                   | pop                 ecx
            //   c20c00               | ret                 0xc
            //   ff15????????         |                     

        $sequence_5 = { b907000000 f7f9 42 89542410 8b5500 }
            // n = 5, score = 200
            //   b907000000           | mov                 ecx, 7
            //   f7f9                 | idiv                ecx
            //   42                   | inc                 edx
            //   89542410             | mov                 dword ptr [esp + 0x10], edx
            //   8b5500               | mov                 edx, dword ptr [ebp]

        $sequence_6 = { 7530 50 50 8b44240c 25ffff0000 50 68???????? }
            // n = 7, score = 200
            //   7530                 | jne                 0x32
            //   50                   | push                eax
            //   50                   | push                eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   25ffff0000           | and                 eax, 0xffff
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_7 = { 81e1ffff0000 c744243400000000 d1e1 85c9 }
            // n = 4, score = 200
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   c744243400000000     | mov                 dword ptr [esp + 0x34], 0
            //   d1e1                 | shl                 ecx, 1
            //   85c9                 | test                ecx, ecx

    condition:
        7 of them and filesize < 221184
}