rule win_netspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.netspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4829c4 488b8538340000 4889e1 48898d704d0000 e8???????? }
            // n = 5, score = 100
            //   4829c4               | mov                 ecx, dword ptr [eax]
            //   488b8538340000       | mov                 eax, ecx
            //   4889e1               | dec                 eax
            //   48898d704d0000       | sub                 esp, eax
            //   e8????????           |                     

        $sequence_1 = { e9???????? 8b858c170000 3da1b579e1 0f84d92c0000 e9???????? 8b858c170000 3da646bcce }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b858c170000         | dec                 eax
            //   3da1b579e1           | mov                 ecx, esp
            //   0f84d92c0000         | dec                 eax
            //   e9????????           |                     
            //   8b858c170000         | mov                 dword ptr [ebp + 0x4d70], ecx
            //   3da646bcce           | dec                 eax

        $sequence_2 = { 48898510130000 8b15???????? 833d????????0a 0f9cc1 }
            // n = 4, score = 100
            //   48898510130000       | dec                 eax
            //   8b15????????         |                     
            //   833d????????0a       |                     
            //   0f9cc1               | mov                 eax, dword ptr [ebp + 0x3438]

        $sequence_3 = { a801 0f8505000000 e9???????? 488b8da0380000 448b859c380000 }
            // n = 5, score = 100
            //   a801                 | je                  0x2ce4
            //   0f8505000000         | mov                 eax, dword ptr [ebp + 0x178c]
            //   e9????????           |                     
            //   488b8da0380000       | cmp                 eax, 0xcebc46a6
            //   448b859c380000       | dec                 eax

        $sequence_4 = { b8a51c0a0c f6c201 0f45c8 488b85c84a0000 8908 8b15???????? }
            // n = 6, score = 100
            //   b8a51c0a0c           | mov                 eax, 0xc0a1ca5
            //   f6c201               | test                dl, 1
            //   0f45c8               | cmovne              ecx, eax
            //   488b85c84a0000       | dec                 eax
            //   8908                 | mov                 eax, dword ptr [ebp + 0x4ac8]
            //   8b15????????         |                     

        $sequence_5 = { 4889e1 48898d90560000 e8???????? 4829c4 }
            // n = 4, score = 100
            //   4889e1               | dec                 eax
            //   48898d90560000       | mov                 ecx, dword ptr [ebp + 0x38a0]
            //   e8????????           |                     
            //   4829c4               | inc                 esp

        $sequence_6 = { e9???????? 488b85384d0000 8b00 8985544d0000 e9???????? 488b85404d0000 8a00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b85384d0000       | mov                 eax, dword ptr [ebp + 0x50d0]
            //   8b00                 | dec                 eax
            //   8985544d0000         | mov                 eax, dword ptr [eax]
            //   e9????????           |                     
            //   488b85404d0000       | dec                 eax
            //   8a00                 | mov                 eax, dword ptr [eax + 0x30]

        $sequence_7 = { 448b855c570000 4889c4 b9bc3715ff b88819ea06 }
            // n = 4, score = 100
            //   448b855c570000       | mov                 eax, dword ptr [ebp + 0x389c]
            //   4889c4               | dec                 eax
            //   b9bc3715ff           | mov                 eax, dword ptr [ebp + 0x4d38]
            //   b88819ea06           | mov                 eax, dword ptr [eax]

    condition:
        7 of them and filesize < 12033024
}