rule win_netwire_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.netwire."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netwire"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744241000000000 c744240c00000000 c744240800000000 c744240400000000 c7042410000000 }
            // n = 5, score = 1200
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c7042410000000       | mov                 dword ptr [esp], 0x10

        $sequence_1 = { c744242c00000000 c744242800000000 c744242400000000 c7442420fdffffff }
            // n = 4, score = 1200
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0
            //   c744242800000000     | mov                 dword ptr [esp + 0x28], 0
            //   c744242400000000     | mov                 dword ptr [esp + 0x24], 0
            //   c7442420fdffffff     | mov                 dword ptr [esp + 0x20], 0xfffffffd

        $sequence_2 = { e8???????? c7042410000000 e8???????? 84c0 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   c7042410000000       | mov                 dword ptr [esp], 0x10
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_3 = { e8???????? c7042446000000 e8???????? c7042449000000 e8???????? c7042446000000 e8???????? }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   c7042446000000       | mov                 dword ptr [esp], 0x46
            //   e8????????           |                     
            //   c7042449000000       | mov                 dword ptr [esp], 0x49
            //   e8????????           |                     
            //   c7042446000000       | mov                 dword ptr [esp], 0x46
            //   e8????????           |                     

        $sequence_4 = { c70424???????? e8???????? a3???????? e9???????? c705????????00000000 e9???????? c7042410020000 }
            // n = 7, score = 1200
            //   c70424????????       |                     
            //   e8????????           |                     
            //   a3????????           |                     
            //   e9????????           |                     
            //   c705????????00000000     |     
            //   e9????????           |                     
            //   c7042410020000       | mov                 dword ptr [esp], 0x210

        $sequence_5 = { e8???????? c7442410000000f0 c744240c01000000 c744240800000000 c744240400000000 c70424???????? }
            // n = 6, score = 1200
            //   e8????????           |                     
            //   c7442410000000f0     | mov                 dword ptr [esp + 0x10], 0xf0000000
            //   c744240c01000000     | mov                 dword ptr [esp + 0xc], 1
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c70424????????       |                     

        $sequence_6 = { 83ec0c c7442408???????? c7442404???????? c70424???????? }
            // n = 4, score = 1200
            //   83ec0c               | sub                 esp, 0xc
            //   c7442408????????     |                     
            //   c7442404????????     |                     
            //   c70424????????       |                     

        $sequence_7 = { 740c c7042400000000 e8???????? c70424???????? e8???????? }
            // n = 5, score = 1200
            //   740c                 | je                  0xe
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     

        $sequence_8 = { c70424???????? e8???????? a3???????? e9???????? c705????????00000000 e9???????? }
            // n = 6, score = 1200
            //   c70424????????       |                     
            //   e8????????           |                     
            //   a3????????           |                     
            //   e9????????           |                     
            //   c705????????00000000     |     
            //   e9????????           |                     

        $sequence_9 = { e8???????? c7042401000000 e8???????? 84c0 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   c7042401000000       | mov                 dword ptr [esp], 1
            //   e8????????           |                     
            //   84c0                 | test                al, al

    condition:
        7 of them and filesize < 416768
}