rule win_neutrino_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.neutrino_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neutrino_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a61 6689955cffffff 5a 6a6e 5f 6a75 5e }
            // n = 7, score = 200
            //   6a61                 | push                0x61
            //   6689955cffffff       | mov                 word ptr [ebp - 0xa4], dx
            //   5a                   | pop                 edx
            //   6a6e                 | push                0x6e
            //   5f                   | pop                 edi
            //   6a75                 | push                0x75
            //   5e                   | pop                 esi

        $sequence_1 = { 8b45d8 8d443001 50 53 e8???????? 8bd8 }
            // n = 6, score = 200
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8d443001             | lea                 eax, [eax + esi + 1]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { 56 57 e8???????? 59 59 8d4df8 51 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx

        $sequence_3 = { 51 53 33ff 57 ffd0 85c0 7433 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7433                 | je                  0x35

        $sequence_4 = { ff75fc ffd0 8945fc 3bc7 0f8580000000 }
            // n = 5, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd0                 | call                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3bc7                 | cmp                 eax, edi
            //   0f8580000000         | jne                 0x86

        $sequence_5 = { 8945e8 83f8ff 0f84a4000000 3bc3 0f849c000000 687823b2ff 56 }
            // n = 7, score = 200
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   83f8ff               | cmp                 eax, -1
            //   0f84a4000000         | je                  0xaa
            //   3bc3                 | cmp                 eax, ebx
            //   0f849c000000         | je                  0xa2
            //   687823b2ff           | push                0xffb22378
            //   56                   | push                esi

        $sequence_6 = { 5a 6a61 6689955cffffff 5a 6a6e }
            // n = 5, score = 200
            //   5a                   | pop                 edx
            //   6a61                 | push                0x61
            //   6689955cffffff       | mov                 word ptr [ebp - 0xa4], dx
            //   5a                   | pop                 edx
            //   6a6e                 | push                0x6e

        $sequence_7 = { 66898d56ffffff 66898d58ffffff 66898d5affffff 66898d5cffffff 66898d5effffff 66898d60ffffff 66898d62ffffff }
            // n = 7, score = 200
            //   66898d56ffffff       | mov                 word ptr [ebp - 0xaa], cx
            //   66898d58ffffff       | mov                 word ptr [ebp - 0xa8], cx
            //   66898d5affffff       | mov                 word ptr [ebp - 0xa6], cx
            //   66898d5cffffff       | mov                 word ptr [ebp - 0xa4], cx
            //   66898d5effffff       | mov                 word ptr [ebp - 0xa2], cx
            //   66898d60ffffff       | mov                 word ptr [ebp - 0xa0], cx
            //   66898d62ffffff       | mov                 word ptr [ebp - 0x9e], cx

        $sequence_8 = { 58 6a43 8bc8 66898d4effffff 59 6a65 66898d50ffffff }
            // n = 7, score = 200
            //   58                   | pop                 eax
            //   6a43                 | push                0x43
            //   8bc8                 | mov                 ecx, eax
            //   66898d4effffff       | mov                 word ptr [ebp - 0xb2], cx
            //   59                   | pop                 ecx
            //   6a65                 | push                0x65
            //   66898d50ffffff       | mov                 word ptr [ebp - 0xb0], cx

        $sequence_9 = { 6a6e 66898558ffffff 58 6a62 6689855affffff 58 }
            // n = 6, score = 200
            //   6a6e                 | push                0x6e
            //   66898558ffffff       | mov                 word ptr [ebp - 0xa8], ax
            //   58                   | pop                 eax
            //   6a62                 | push                0x62
            //   6689855affffff       | mov                 word ptr [ebp - 0xa6], ax
            //   58                   | pop                 eax

    condition:
        7 of them and filesize < 188416
}