rule win_new_ct_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.new_ct."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.new_ct"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7428 a1???????? 8d8c2478020000 50 68???????? 68???????? }
            // n = 6, score = 200
            //   7428                 | je                  0x2a
            //   a1????????           |                     
            //   8d8c2478020000       | lea                 ecx, [esp + 0x278]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     

        $sequence_1 = { 83fe06 0f8f1f010000 83fe03 0f8e16010000 8b4508 803805 0f850a010000 }
            // n = 7, score = 200
            //   83fe06               | cmp                 esi, 6
            //   0f8f1f010000         | jg                  0x125
            //   83fe03               | cmp                 esi, 3
            //   0f8e16010000         | jle                 0x11c
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   803805               | cmp                 byte ptr [eax], 5
            //   0f850a010000         | jne                 0x110

        $sequence_2 = { 81ec00040000 53 56 6888030000 33db }
            // n = 5, score = 200
            //   81ec00040000         | sub                 esp, 0x400
            //   53                   | push                ebx
            //   56                   | push                esi
            //   6888030000           | push                0x388
            //   33db                 | xor                 ebx, ebx

        $sequence_3 = { 8b8680030000 8d542414 52 03c7 6800400000 50 53 }
            // n = 7, score = 200
            //   8b8680030000         | mov                 eax, dword ptr [esi + 0x380]
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   52                   | push                edx
            //   03c7                 | add                 eax, edi
            //   6800400000           | push                0x4000
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_4 = { 68???????? 8bce e8???????? 89b5b0f3ffff 89b5b4f3ffff 85f6 7410 }
            // n = 7, score = 200
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   89b5b0f3ffff         | mov                 dword ptr [ebp - 0xc50], esi
            //   89b5b4f3ffff         | mov                 dword ptr [ebp - 0xc4c], esi
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12

        $sequence_5 = { 8944242c 8d542430 89442430 51 89442438 52 89442440 }
            // n = 7, score = 200
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   8d542430             | lea                 edx, [esp + 0x30]
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   51                   | push                ecx
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   52                   | push                edx
            //   89442440             | mov                 dword ptr [esp + 0x40], eax

        $sequence_6 = { 50 68???????? 6a10 68???????? ffd3 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   ffd3                 | call                ebx

        $sequence_7 = { f3a4 8dbdccfdffff 83c9ff 33c0 f2ae f7d1 49 }
            // n = 7, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbdccfdffff         | lea                 edi, [ebp - 0x234]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx

        $sequence_8 = { 8b5508 8b420c 85c0 740f 8985c8f6ffff 50 }
            // n = 6, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8985c8f6ffff         | mov                 dword ptr [ebp - 0x938], eax
            //   50                   | push                eax

        $sequence_9 = { f3a4 b900010000 8dbc2470020000 f3ab }
            // n = 4, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   b900010000           | mov                 ecx, 0x100
            //   8dbc2470020000       | lea                 edi, [esp + 0x270]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 122880
}