rule win_nexster_bot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nexster_bot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nexster_bot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a4701 47 84c0 75f8 8b0d???????? 8d84240c010000 }
            // n = 6, score = 100
            //   8a4701               | mov                 al, byte ptr [edi + 1]
            //   47                   | inc                 edi
            //   84c0                 | test                al, al
            //   75f8                 | jne                 0xfffffffa
            //   8b0d????????         |                     
            //   8d84240c010000       | lea                 eax, [esp + 0x10c]

        $sequence_1 = { 6a00 8908 668b0d???????? 6a00 895004 68000000c0 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8908                 | mov                 dword ptr [eax], ecx
            //   668b0d????????       |                     
            //   6a00                 | push                0
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   68000000c0           | push                0xc0000000

        $sequence_2 = { 42 3acb 75f6 8dbd00080000 8db5000c0000 e8???????? }
            // n = 6, score = 100
            //   42                   | inc                 edx
            //   3acb                 | cmp                 cl, bl
            //   75f6                 | jne                 0xfffffff8
            //   8dbd00080000         | lea                 edi, [ebp + 0x800]
            //   8db5000c0000         | lea                 esi, [ebp + 0xc00]
            //   e8????????           |                     

        $sequence_3 = { e8???????? 8b54241c 68???????? 8bf0 52 8d44241c 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   68????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   52                   | push                edx
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax

        $sequence_4 = { 33c0 8da42400000000 8a1485d0604100 889405000e0000 40 83f80b }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8da42400000000       | lea                 esp, [esp]
            //   8a1485d0604100       | mov                 dl, byte ptr [eax*4 + 0x4160d0]
            //   889405000e0000       | mov                 byte ptr [ebp + eax + 0xe00], dl
            //   40                   | inc                 eax
            //   83f80b               | cmp                 eax, 0xb

        $sequence_5 = { 8d842480000000 50 ff15???????? 8b3d???????? }
            // n = 4, score = 100
            //   8d842480000000       | lea                 eax, [esp + 0x80]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_6 = { 8d0cbd20804100 8901 8305????????20 8b11 81c200080000 }
            // n = 5, score = 100
            //   8d0cbd20804100       | lea                 ecx, [edi*4 + 0x418020]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8305????????20       |                     
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   81c200080000         | add                 edx, 0x800

        $sequence_7 = { 85c0 0f8581000000 80bc24ae01000001 7533 8b0d???????? 8b15???????? }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f8581000000         | jne                 0x87
            //   80bc24ae01000001     | cmp                 byte ptr [esp + 0x1ae], 1
            //   7533                 | jne                 0x35
            //   8b0d????????         |                     
            //   8b15????????         |                     

        $sequence_8 = { 84c0 75f6 8d85c0140000 48 }
            // n = 4, score = 100
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   8d85c0140000         | lea                 eax, [ebp + 0x14c0]
            //   48                   | dec                 eax

        $sequence_9 = { 75f9 8b1424 6a00 2bc1 8d4c242c }
            // n = 5, score = 100
            //   75f9                 | jne                 0xfffffffb
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   6a00                 | push                0
            //   2bc1                 | sub                 eax, ecx
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

    condition:
        7 of them and filesize < 245760
}