rule win_ngioweb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ngioweb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ngioweb"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bfb 763d 33c0 395d14 8d747efe 0f95c0 894508 }
            // n = 7, score = 500
            //   3bfb                 | cmp                 edi, ebx
            //   763d                 | jbe                 0x3f
            //   33c0                 | xor                 eax, eax
            //   395d14               | cmp                 dword ptr [ebp + 0x14], ebx
            //   8d747efe             | lea                 esi, [esi + edi*2 - 2]
            //   0f95c0               | setne               al
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_1 = { 7569 8b4510 2b45cc 6a16 6a05 50 ff750c }
            // n = 7, score = 500
            //   7569                 | jne                 0x6b
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   2b45cc               | sub                 eax, dword ptr [ebp - 0x34]
            //   6a16                 | push                0x16
            //   6a05                 | push                5
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_2 = { 03c0 50 56 e8???????? 57 56 8945e8 }
            // n = 7, score = 500
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   57                   | push                edi
            //   56                   | push                esi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_3 = { 8b442404 85c0 7408 8b809c000000 eb02 33c0 c20400 }
            // n = 7, score = 500
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   8b809c000000         | mov                 eax, dword ptr [eax + 0x9c]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   c20400               | ret                 4

        $sequence_4 = { 50 6a10 8d4604 50 e8???????? eb46 80fa03 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   6a10                 | push                0x10
            //   8d4604               | lea                 eax, [esi + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb46                 | jmp                 0x48
            //   80fa03               | cmp                 dl, 3

        $sequence_5 = { 51 ffd0 8b5f14 68159fa331 56 e8???????? 53 }
            // n = 7, score = 500
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   8b5f14               | mov                 ebx, dword ptr [edi + 0x14]
            //   68159fa331           | push                0x31a39f15
            //   56                   | push                esi
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_6 = { ff742408 e8???????? 6a00 56 e8???????? 33c0 5e }
            // n = 7, score = 500
            //   ff742408             | push                dword ptr [esp + 8]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi

        $sequence_7 = { ff7508 e8???????? 85c0 7531 ff7508 e8???????? 6a00 }
            // n = 7, score = 500
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7531                 | jne                 0x33
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_8 = { 66c745f86900 66c745f67600 66c745f46700 66c745f26200 66c745f06400 668975ee 66c745ec4700 }
            // n = 7, score = 500
            //   66c745f86900         | mov                 word ptr [ebp - 8], 0x69
            //   66c745f67600         | mov                 word ptr [ebp - 0xa], 0x76
            //   66c745f46700         | mov                 word ptr [ebp - 0xc], 0x67
            //   66c745f26200         | mov                 word ptr [ebp - 0xe], 0x62
            //   66c745f06400         | mov                 word ptr [ebp - 0x10], 0x64
            //   668975ee             | mov                 word ptr [ebp - 0x12], si
            //   66c745ec4700         | mov                 word ptr [ebp - 0x14], 0x47

        $sequence_9 = { 395d0c 750d 8b85d8fdffff 85c0 8945fc 7519 }
            // n = 6, score = 500
            //   395d0c               | cmp                 dword ptr [ebp + 0xc], ebx
            //   750d                 | jne                 0xf
            //   8b85d8fdffff         | mov                 eax, dword ptr [ebp - 0x228]
            //   85c0                 | test                eax, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   7519                 | jne                 0x1b

    condition:
        7 of them and filesize < 204800
}