rule win_nim_blackout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nim_blackout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nim_blackout"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 4889e5 4883ec30 48894d10 488b05???????? 4885c0 750d }
            // n = 7, score = 100
            //   55                   | mov                 eax, dword ptr [eax + edx*8]
            //   4889e5               | dec                 eax
            //   4883ec30             | mov                 edx, dword ptr [ebp + 0x88]
            //   48894d10             | dec                 eax
            //   488b05????????       |                     
            //   4885c0               | mov                 ecx, eax
            //   750d                 | dec                 eax

        $sequence_1 = { 488b00 eb05 b800000000 483b85a8000000 7f30 4883bdf800000000 }
            // n = 6, score = 100
            //   488b00               | dec                 eax
            //   eb05                 | lea                 eax, [ebp - 0x10]
            //   b800000000           | dec                 eax
            //   483b85a8000000       | mov                 dword ptr [eax], ecx
            //   7f30                 | dec                 eax
            //   4883bdf800000000     | sub                 eax, 4

        $sequence_2 = { 48c745c0c0000000 488d05ad7e0100 488945c8 488b45f0 488945f8 eb40 90 }
            // n = 7, score = 100
            //   48c745c0c0000000     | dec                 eax
            //   488d05ad7e0100       | mov                 eax, dword ptr [ebp - 0x18]
            //   488945c8             | dec                 eax
            //   488b45f0             | mov                 eax, dword ptr [ebp - 0x18]
            //   488945f8             | dec                 eax
            //   eb40                 | lea                 edx, [0x1e7fc]
            //   90                   | dec                 eax

        $sequence_3 = { 48c1e003 4801d0 488b00 4885c0 741a 488b4510 488b5008 }
            // n = 7, score = 100
            //   48c1e003             | mov                 eax, dword ptr [eax]
            //   4801d0               | jmp                 0x5b3
            //   488b00               | mov                 eax, 0
            //   4885c0               | dec                 eax
            //   741a                 | cmp                 eax, dword ptr [ebp - 0x18]
            //   488b4510             | jg                  0x5d6
            //   488b5008             | dec                 eax

        $sequence_4 = { 488905???????? 488b05???????? 4885c0 750c 488d0d229c0100 e8???????? 488b05???????? }
            // n = 7, score = 100
            //   488905????????       |                     
            //   488b05????????       |                     
            //   4885c0               | dec                 eax
            //   750c                 | mov                 ebx, dword ptr [esp + 0x58]
            //   488d0d229c0100       | dec                 eax
            //   e8????????           |                     
            //   488b05????????       |                     

        $sequence_5 = { 488b45f8 488905???????? eb01 90 e8???????? 90 4883c460 }
            // n = 7, score = 100
            //   488b45f8             | mov                 edx, eax
            //   488905????????       |                     
            //   eb01                 | dec                 eax
            //   90                   | mov                 ecx, dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   4883c460             | mov                 dword ptr [ebp - 8], eax

        $sequence_6 = { 488d05dd770100 488945e8 488b4510 488b00 ba08000000 4889c1 e8???????? }
            // n = 7, score = 100
            //   488d05dd770100       | dec                 eax
            //   488945e8             | mov                 eax, dword ptr [ebp + 0x90]
            //   488b4510             | dec                 eax
            //   488b00               | add                 eax, 8
            //   ba08000000           | mov                 edx, 0
            //   4889c1               | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { 488945f8 48c745d07b000000 488d05d02a0200 488945d8 488b45f8 488d14c500000000 488b4518 }
            // n = 7, score = 100
            //   488945f8             | dec                 eax
            //   48c745d07b000000     | lea                 ecx, [0x8416]
            //   488d05d02a0200       | mov                 dword ptr [eax], 1
            //   488945d8             | cmove               eax, dword ptr [esp + 0x48]
            //   488b45f8             | mov                 dword ptr [esp + 0x48], eax
            //   488d14c500000000     | movzx               edx, byte ptr [eax - 1]
            //   488b4518             | dec                 eax

        $sequence_8 = { 488d05ed680100 48894558 ba00000000 488b85b8000000 4883c001 7105 ba01000000 }
            // n = 7, score = 100
            //   488d05ed680100       | and                 eax, 1
            //   48894558             | test                al, al
            //   ba00000000           | je                  0x536
            //   488b85b8000000       | dec                 eax
            //   4883c001             | mov                 eax, dword ptr [ebp - 0x28]
            //   7105                 | and                 eax, 1
            //   ba01000000           | dec                 eax

        $sequence_9 = { 488d05d2af0200 488945e8 488b5510 488b05???????? 488d4818 e8???????? e8???????? }
            // n = 7, score = 100
            //   488d05d2af0200       | mov                 dword ptr [eax], edx
            //   488945e8             | dec                 eax
            //   488b5510             | mov                 eax, ecx
            //   488b05????????       |                     
            //   488d4818             | and                 eax, 1
            //   e8????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1068032
}