rule win_nimbo_c2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nimbo_c2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimbo_c2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7411 488b09 ba02000000 e8???????? c6430800 4883c420 5b }
            // n = 7, score = 500
            //   7411                 | jmp                 0x1b78
            //   488b09               | xor                 ebx, ebx
            //   ba02000000           | jmp                 0x1b78
            //   e8????????           |                     
            //   c6430800             | dec                 eax
            //   4883c420             | lea                 edx, [0x2b989]
            //   5b                   | dec                 esp

        $sequence_1 = { 48c7c0fcffffff 4885d2 7407 488b02 4883e804 488d4c0210 ba04000000 }
            // n = 7, score = 500
            //   48c7c0fcffffff       | dec                 eax
            //   4885d2               | mov                 ecx, eax
            //   7407                 | je                  0xbde
            //   488b02               | dec                 eax
            //   4883e804             | test                esi, esi
            //   488d4c0210           | je                  0xbc7
            //   ba04000000           | dec                 esp

        $sequence_2 = { 498d8c24b0000000 4889c2 e8???????? 4c89e0 41c68424b800000001 4883c420 }
            // n = 6, score = 500
            //   498d8c24b0000000     | mov                 ecx, esi
            //   4889c2               | jmp                 0xeb
            //   e8????????           |                     
            //   4c89e0               | dec                 eax
            //   41c68424b800000001     | lea    edx, [0x2f631]
            //   4883c420             | xor                 edx, edx

        $sequence_3 = { 4819db 4889c1 488985c0feffff e8???????? 83e313 488d8df8feffff 4881c306000200 }
            // n = 7, score = 500
            //   4819db               | sub                 edx, dword ptr [esp + 0x38]
            //   4889c1               | dec                 eax
            //   488985c0feffff       | sub                 edx, edi
            //   e8????????           |                     
            //   83e313               | dec                 eax
            //   488d8df8feffff       | lea                 ecx, [esp + 0x30]
            //   4881c306000200       | mov                 edx, 1

        $sequence_4 = { e8???????? 90 4883c438 c3 488b05???????? 48ff20 488b05???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   90                   | mov                 edx, 2
            //   4883c438             | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x28], 0
            //   488b05????????       |                     
            //   48ff20               | dec                 eax
            //   488b05????????       |                     

        $sequence_5 = { 7f1c 488b8df8fbffff e8???????? 4889f2 4989c7 4885c0 7432 }
            // n = 7, score = 500
            //   7f1c                 | dec                 eax
            //   488b8df8fbffff       | mov                 esi, dword ptr [eax]
            //   e8????????           |                     
            //   4889f2               | dec                 eax
            //   4989c7               | sub                 esi, 4
            //   4885c0               | movzx               ecx, cl
            //   7432                 | dec                 eax

        $sequence_6 = { 6605bb01 488b4c2450 0fb7d0 41b901000000 41b806000000 e8???????? 4889d9 }
            // n = 7, score = 500
            //   6605bb01             | dec                 eax
            //   488b4c2450           | lea                 edx, [0xffffff9a]
            //   0fb7d0               | mov                 ecx, 2
            //   41b901000000         | nop                 
            //   41b806000000         | dec                 eax
            //   e8????????           |                     
            //   4889d9               | sub                 esp, 0x28

        $sequence_7 = { 4889c6 4d85f6 740d 4889fa 4c89f1 e8???????? eb07 }
            // n = 7, score = 500
            //   4889c6               | mov                 dword ptr [esp + 0x60], eax
            //   4d85f6               | dec                 ebx
            //   740d                 | lea                 ebx, [esp]
            //   4889fa               | dec                 esi
            //   4c89f1               | mov                 esi, dword ptr [eax + 0x10]
            //   e8????????           |                     
            //   eb07                 | dec                 ebp

        $sequence_8 = { 4889c2 eb28 4d8d46ff 4c89e1 e8???????? 4c89f9 4889c2 }
            // n = 7, score = 500
            //   4889c2               | lea                 eax, [edx + 0x150]
            //   eb28                 | dec                 eax
            //   4d8d46ff             | lea                 eax, [0x5a1f0]
            //   4c89e1               | dec                 ecx
            //   e8????????           |                     
            //   4c89f9               | lea                 eax, [edx + 0x150]
            //   4889c2               | dec                 eax

        $sequence_9 = { 57 56 53 4883ec20 488bb42488000000 4c8b32 4889f5 }
            // n = 7, score = 500
            //   57                   | lea                 ecx, [0x28c77]
            //   56                   | dec                 eax
            //   53                   | mov                 dword ptr [esp + 0x20], 0x433
            //   4883ec20             | dec                 esp
            //   488bb42488000000     | lea                 eax, [0x28c6f]
            //   4c8b32               | dec                 eax
            //   4889f5               | mov                 ecx, eax

    condition:
        7 of them and filesize < 1141760
}