rule win_nimplant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nimplant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimplant"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d05a49c0400 e8???????? 4885db 740f 48b80000000000000040 488503 }
            // n = 6, score = 100
            //   4c8d05a49c0400       | mov                 ecx, dword ptr [esp + 0x118]
            //   e8????????           |                     
            //   4885db               | jne                 0x164e
            //   740f                 | dec                 eax
            //   48b80000000000000040     | lea    ecx, [esp + 0x160]
            //   488503               | dec                 esp

        $sequence_1 = { 4d85e4 0f8886000000 410fb6443c08 89c2 83e2fd 80fa3c 7404 }
            // n = 7, score = 100
            //   4d85e4               | dec                 eax
            //   0f8886000000         | mov                 ecx, dword ptr [esp + 0x48]
            //   410fb6443c08         | dec                 ecx
            //   89c2                 | xor                 edi, ebp
            //   83e2fd               | dec                 eax
            //   80fa3c               | xor                 edi, edx
            //   7404                 | dec                 ebp

        $sequence_2 = { 4d29dd 4801fe 488d4802 4839d1 7c16 4801d2 4883c003 }
            // n = 7, score = 100
            //   4d29dd               | mov                 edx, esp
            //   4801fe               | dec                 esp
            //   488d4802             | mov                 ecx, ebp
            //   4839d1               | cmp                 byte ptr [ebx], 0
            //   7c16                 | dec                 eax
            //   4801d2               | mov                 ebp, dword ptr [esp + 0x48]
            //   4883c003             | dec                 eax

        $sequence_3 = { 744a 488d4c2430 4c89ea e8???????? 488b7c2430 0fb62b 4c89e9 }
            // n = 7, score = 100
            //   744a                 | add                 eax, 0x10
            //   488d4c2430           | jo                  0x2d3
            //   4c89ea               | dec                 ecx
            //   e8????????           |                     
            //   488b7c2430           | mov                 dword ptr [esp - 0x10], eax
            //   0fb62b               | cmp                 byte ptr [esi], 0
            //   4c89e9               | jne                 0x21e

        $sequence_4 = { 4c8b11 4c8b5908 488b02 4c89c3 4c8b4208 4c8d6c2430 4989d4 }
            // n = 7, score = 100
            //   4c8b11               | dec                 eax
            //   4c8b5908             | and                 eax, 0xfffff000
            //   488b02               | dec                 esp
            //   4c89c3               | mov                 eax, dword ptr [eax + 8]
            //   4c8b4208             | dec                 ecx
            //   4c8d6c2430           | lea                 eax, [eax - 0x30]
            //   4989d4               | dec                 ecx

        $sequence_5 = { 498b4708 420fb6440807 3c5c 744d 3c2f 7449 ba01000000 }
            // n = 7, score = 100
            //   498b4708             | test                eax, eax
            //   420fb6440807         | jle                 0x4f0
            //   3c5c                 | dec                 ecx
            //   744d                 | mov                 eax, dword ptr [esp + 0x18]
            //   3c2f                 | dec                 eax
            //   7449                 | mov                 dword ptr [esp + 0x68], edx
            //   ba01000000           | inc                 ebp

        $sequence_6 = { 4c89fa 4c89c9 4c894c2438 e8???????? 0fb63b 4c8b7c2458 4c8b4c2438 }
            // n = 7, score = 100
            //   4c89fa               | dec                 esp
            //   4c89c9               | mov                 esi, ebp
            //   4c894c2438           | dec                 eax
            //   e8????????           |                     
            //   0fb63b               | mov                 ebx, ebp
            //   4c8b7c2458           | dec                 ebp
            //   4c8b4c2438           | mov                 ebp, edx

        $sequence_7 = { 48897c2438 0f8093030000 4885c0 0f88c2050000 488d7c2470 4889c2 488dac2480000000 }
            // n = 7, score = 100
            //   48897c2438           | mov                 eax, dword ptr [esp + 0x58]
            //   0f8093030000         | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 0x58], edx
            //   0f88c2050000         | dec                 eax
            //   488d7c2470           | mov                 edx, edi
            //   4889c2               | dec                 eax
            //   488dac2480000000     | mov                 eax, dword ptr [esp + 0x40]

        $sequence_8 = { 4c894c2448 4c895c2440 e8???????? 4c8b5c2440 4c8b4c2448 4d01d9 0f8050020000 }
            // n = 7, score = 100
            //   4c894c2448           | dec                 eax
            //   4c895c2440           | lea                 edx, [eax + 8]
            //   e8????????           |                     
            //   4c8b5c2440           | dec                 esp
            //   4c8b4c2448           | mov                 ecx, dword ptr [esp + 0x40]
            //   4d01d9               | dec                 esp
            //   0f8050020000         | mov                 ebx, dword ptr [esp + 0x48]

        $sequence_9 = { e8???????? 0fb62b 4084ed 0f85d6fdffff 89f0 488d9424f0000000 c744242001000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb62b               | mov                 dword ptr [esp + 0x28], 0x400
            //   4084ed               | mov                 dword ptr [esp + 0x20], 0x400
            //   0f85d6fdffff         | call                dword ptr [edi]
            //   89f0                 | dec                 eax
            //   488d9424f0000000     | mov                 dword ptr [esp + 0x58], eax
            //   c744242001000000     | dec                 eax

    condition:
        7 of them and filesize < 1811456
}