rule win_nimrev_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nimrev."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimrev"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8845ef eb01 90 807def00 }
            // n = 4, score = 200
            //   8845ef               | dec                 eax
            //   eb01                 | mov                 dword ptr [ebp - 0x50], 0x130
            //   90                   | dec                 eax
            //   807def00             | lea                 eax, [0x1c276]

        $sequence_1 = { 0fb600 3c5f 7507 b801000000 }
            // n = 4, score = 200
            //   0fb600               | jmp                 0x33
            //   3c5f                 | nop                 
            //   7507                 | setle               al
            //   b801000000           | mov                 byte ptr [ebp - 0xd], al

        $sequence_2 = { 3c7d 7407 b801000000 eb05 }
            // n = 4, score = 200
            //   3c7d                 | cmp                 edx, eax
            //   7407                 | setb                al
            //   b801000000           | movzx               edx, al
            //   eb05                 | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_3 = { 7507 b801000000 eb05 b800000000 8845f7 eb01 90 }
            // n = 7, score = 200
            //   7507                 | mov                 eax, dword ptr [ebp + 0x20]
            //   b801000000           | dec                 eax
            //   eb05                 | lea                 eax, [0x1d9e2]
            //   b800000000           | dec                 eax
            //   8845f7               | mov                 dword ptr [ebp - 0x28], eax
            //   eb01                 | dec                 eax
            //   90                   | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_4 = { 0fb600 3c7d 7407 b801000000 eb05 b800000000 }
            // n = 6, score = 200
            //   0fb600               | cmp                 dword ptr [ebp - 0x1c], 0
            //   3c7d                 | je                  0x19d7
            //   7407                 | mov                 edx, dword ptr [ebp - 0xc]
            //   b801000000           | mov                 dword ptr [edx + 0xc], eax
            //   eb05                 | cmp                 dword ptr [ebp - 0x10], 0
            //   b800000000           | je                  0x19de

        $sequence_5 = { ffd0 90 e9???????? 90 b9d0070000 }
            // n = 5, score = 200
            //   ffd0                 | dec                 eax
            //   90                   | mov                 dword ptr [ebp - 0x288], eax
            //   e9????????           |                     
            //   90                   | dec                 eax
            //   b9d0070000           | mov                 eax, dword ptr [ebp - 0x288]

        $sequence_6 = { c1e002 01d0 01c0 29c1 89c8 83c030 89c1 }
            // n = 7, score = 200
            //   c1e002               | mov                 ebp, esp
            //   01d0                 | sub                 esp, 0x18
            //   01c0                 | mov                 dword ptr [esp], 1
            //   29c1                 | push                ebp
            //   89c8                 | mov                 ebp, esp
            //   83c030               | sub                 esp, 0x28
            //   89c1                 | mov                 ebp, esp

        $sequence_7 = { 89c2 89d0 c1e002 01d0 01c0 29c1 89c8 }
            // n = 7, score = 200
            //   89c2                 | sub                 esp, 0x28
            //   89d0                 | mov                 dword ptr [ebp - 0xc], 0
            //   c1e002               | mov                 dword ptr [ebp - 0x10], 0
            //   01d0                 | mov                 ecx, 0x7d0
            //   01c0                 | push                ebp
            //   29c1                 | mov                 ebp, esp
            //   89c8                 | sub                 esp, 0x28

        $sequence_8 = { 83f001 84c0 7408 90 e8???????? eb01 }
            // n = 6, score = 200
            //   83f001               | mov                 dword ptr [ebp - 0x40], 0xdc
            //   84c0                 | dec                 eax
            //   7408                 | mov                 dword ptr [ebp - 0x40], 0xdc
            //   90                   | dec                 eax
            //   e8????????           |                     
            //   eb01                 | lea                 eax, [0x22246]

        $sequence_9 = { 0f9ec0 8845ef eb01 90 807def00 }
            // n = 5, score = 200
            //   0f9ec0               | mov                 eax, dword ptr [ebp - 0x7c]
            //   8845ef               | not                 eax
            //   eb01                 | mov                 dword ptr [ebp - 0xdc], 0x4235f0
            //   90                   | mov                 byte ptr [ebp - 0x35], 0
            //   807def00             | mov                 eax, dword ptr [ebp - 0x34]

    condition:
        7 of them and filesize < 1141760
}