rule win_ninerat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ninerat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ninerat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89ad58feffff 48894d10 48895518 488b4518 48c70000000000 48c7400800000000 48c78590feffff00000000 }
            // n = 7, score = 400
            //   4c89ad58feffff       | dec                 esp
            //   48894d10             | mov                 dword ptr [ebp - 0x90], edi
            //   48895518             | dec                 eax
            //   488b4518             | mov                 dword ptr [ebp + 0x10], ecx
            //   48c70000000000       | dec                 esp
            //   48c7400800000000     | mov                 dword ptr [ebp - 0x1a0], ebp
            //   48c78590feffff00000000     | dec    esp

        $sequence_1 = { 4c89ad60ffffff 4c89b568ffffff 4c89bd70ffffff 48894d10 }
            // n = 4, score = 400
            //   4c89ad60ffffff       | jl                  0x3e
            //   4c89b568ffffff       | inc                 ebp
            //   4c89bd70ffffff       | mov                 edx, ecx
            //   48894d10             | dec                 ecx

        $sequence_2 = { 4c89ad58ffffff 4c89b560ffffff 4c89bd68ffffff 48894d10 4889d3 4d89c4 498bd4 }
            // n = 7, score = 400
            //   4c89ad58ffffff       | mov                 al, byte ptr [esi + edi]
            //   4c89b560ffffff       | inc                 edx
            //   4c89bd68ffffff       | dec                 edx
            //   48894d10             | mov                 ecx, dword ptr [ebx + 0x1c6f0]
            //   4889d3               | dec                 eax
            //   4d89c4               | add                 ecx, edi
            //   498bd4               | dec                 esp

        $sequence_3 = { 4c89ad50ffffff 4c89b558ffffff 4c89bd60ffffff 48894d10 4889d6 c68570ffffff00 488d4580 }
            // n = 7, score = 400
            //   4c89ad50ffffff       | mov                 ebx, edx
            //   4c89b558ffffff       | dec                 esp
            //   4c89bd60ffffff       | mov                 dword ptr [ebp - 0x1a8], ebp
            //   48894d10             | dec                 eax
            //   4889d6               | mov                 dword ptr [ebp + 0x10], ecx
            //   c68570ffffff00       | dec                 eax
            //   488d4580             | mov                 dword ptr [ebp + 0x18], edx

        $sequence_4 = { 4c89ad68fcffff 4c89b570fcffff 4c89bd78fcffff 48894d10 }
            // n = 4, score = 400
            //   4c89ad68fcffff       | mov                 eax, dword ptr [esp + 0x50]
            //   4c89b570fcffff       | dec                 eax
            //   4c89bd78fcffff       | mov                 dword ptr [esp + 0x238], eax
            //   48894d10             | cmp                 edx, 4

        $sequence_5 = { 4c89ad50ffffff 4c89b558ffffff 4c89bd60ffffff 48895518 4989cc 48c70200000000 4889d1 }
            // n = 7, score = 400
            //   4c89ad50ffffff       | mov                 dword ptr [ebp - 0xa0], esi
            //   4c89b558ffffff       | dec                 esp
            //   4c89bd60ffffff       | mov                 dword ptr [ebp - 0x98], edi
            //   48895518             | dec                 eax
            //   4989cc               | mov                 dword ptr [ebp + 0x10], ecx
            //   48c70200000000       | dec                 eax
            //   4889d1               | mov                 ebx, edx

        $sequence_6 = { 4c89ad60feffff 4c89b568feffff 48894d10 488d4d10 e8???????? 48898570feffff }
            // n = 6, score = 400
            //   4c89ad60feffff       | shr                 edx, 2
            //   4c89b568feffff       | inc                 ecx
            //   48894d10             | mov                 eax, edx
            //   488d4d10             | neg                 eax
            //   e8????????           |                     
            //   48898570feffff       | dec                 eax

        $sequence_7 = { 4c89ad58fdffff 4c89b560fdffff 4c89bd68fdffff 48895518 4c894520 4c894d28 }
            // n = 6, score = 400
            //   4c89ad58fdffff       | dec                 esp
            //   4c89b560fdffff       | mov                 dword ptr [ebp - 0x1a0], ebp
            //   4c89bd68fdffff       | dec                 esp
            //   48895518             | mov                 dword ptr [ebp - 0x198], esi
            //   4c894520             | dec                 eax
            //   4c894d28             | mov                 dword ptr [ebp + 0x10], ecx

        $sequence_8 = { eb0f 488bd3 488d0d48900100 e8???????? }
            // n = 4, score = 100
            //   eb0f                 | lea                 eax, [0x158a8]
            //   488bd3               | dec                 ebp
            //   488d0d48900100       | test                ecx, ecx
            //   e8????????           |                     

        $sequence_9 = { 4889842430020000 4c89642450 488b442450 4889842438020000 }
            // n = 4, score = 100
            //   4889842430020000     | mov                 edx, esp
            //   4c89642450           | movsd               xmm0, qword ptr [eax]
            //   488b442450           | mov                 ebx, dword ptr [eax + 8]
            //   4889842438020000     | dec                 eax

        $sequence_10 = { 4889842480000000 488d1529890100 488d8c2480000000 e8???????? 90 e8???????? 90 }
            // n = 7, score = 100
            //   4889842480000000     | jmp                 0x11
            //   488d1529890100       | dec                 eax
            //   488d8c2480000000     | mov                 edx, ebx
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [0x19048]

        $sequence_11 = { 488d842430030000 48ffc7 6644393478 75f6 }
            // n = 4, score = 100
            //   488d842430030000     | dec                 eax
            //   48ffc7               | lea                 eax, [0xde8d]
            //   6644393478           | dec                 edx
            //   75f6                 | mov                 ecx, dword ptr [eax + ebp*8]

        $sequence_12 = { 4883ec38 834c2448ff 488d05a8580100 4d85c9 }
            // n = 4, score = 100
            //   4883ec38             | dec                 eax
            //   834c2448ff           | sub                 esp, 0x38
            //   488d05a8580100       | or                  dword ptr [esp + 0x48], 0xffffffff
            //   4d85c9               | dec                 eax

        $sequence_13 = { 4a8b04e8 42385cf839 0f84c2000000 488d058dde0000 4a8b0ce8 }
            // n = 5, score = 100
            //   4a8b04e8             | dec                 eax
            //   42385cf839           | lea                 ecx, [esp + 0x80]
            //   0f84c2000000         | nop                 
            //   488d058dde0000       | nop                 
            //   4a8b0ce8             | inc                 ecx

        $sequence_14 = { 418bd4 e8???????? f20f1000 8b5808 e9???????? 488d05cbdd0000 }
            // n = 6, score = 100
            //   418bd4               | dec                 eax
            //   e8????????           |                     
            //   f20f1000             | mov                 dword ptr [esp + 0x80], eax
            //   8b5808               | dec                 eax
            //   e9????????           |                     
            //   488d05cbdd0000       | lea                 edx, [0x18929]

        $sequence_15 = { 83fa04 7c39 458bd1 49c1ea02 418bc2 f7d8 }
            // n = 6, score = 100
            //   83fa04               | lea                 eax, [0xddcb]
            //   7c39                 | dec                 edx
            //   458bd1               | mov                 eax, dword ptr [eax + ebp*8]
            //   49c1ea02             | inc                 edx
            //   418bc2               | cmp                 byte ptr [eax + edi*8 + 0x39], bl
            //   f7d8                 | je                  0xc8

    condition:
        7 of them and filesize < 7709696
}