rule win_nitol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nitol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nitol"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8554ffffff 50 e8???????? 83c420 bffa000000 }
            // n = 5, score = 200
            //   8d8554ffffff         | lea                 eax, [ebp - 0xac]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   bffa000000           | mov                 edi, 0xfa

        $sequence_1 = { 8945e4 51 ff75ec 50 ff7508 ff15???????? }
            // n = 6, score = 200
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   51                   | push                ecx
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

        $sequence_2 = { 57 ffd3 45 3bae08010000 7cd6 57 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   45                   | inc                 ebp
            //   3bae08010000         | cmp                 ebp, dword ptr [esi + 0x108]
            //   7cd6                 | jl                  0xffffffd8
            //   57                   | push                edi

        $sequence_3 = { 896c2434 8d442434 6a04 bd05100000 50 55 }
            // n = 6, score = 200
            //   896c2434             | mov                 dword ptr [esp + 0x34], ebp
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   6a04                 | push                4
            //   bd05100000           | mov                 ebp, 0x1005
            //   50                   | push                eax
            //   55                   | push                ebp

        $sequence_4 = { 55 8bec 81ec20020000 c645e0cf c645e185 c645e2cc c645e3c4 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec20020000         | sub                 esp, 0x220
            //   c645e0cf             | mov                 byte ptr [ebp - 0x20], 0xcf
            //   c645e185             | mov                 byte ptr [ebp - 0x1f], 0x85
            //   c645e2cc             | mov                 byte ptr [ebp - 0x1e], 0xcc
            //   c645e3c4             | mov                 byte ptr [ebp - 0x1d], 0xc4

        $sequence_5 = { 5b 55 8bec 81ec18050000 56 }
            // n = 5, score = 200
            //   5b                   | pop                 ebx
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec18050000         | sub                 esp, 0x518
            //   56                   | push                esi

        $sequence_6 = { 50 e8???????? 83c424 8d8560ffffff 66c745f00200 50 ff15???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]
            //   66c745f00200         | mov                 word ptr [ebp - 0x10], 2
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { ff15???????? 85c0 7d16 ff742404 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7d16                 | jge                 0x18
            //   ff742404             | push                dword ptr [esp + 4]

        $sequence_8 = { ffd6 ffb530ffffff 668945d8 ffd6 6800e9a435 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   ffb530ffffff         | push                dword ptr [ebp - 0xd0]
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   ffd6                 | call                esi
            //   6800e9a435           | push                0x35a4e900

        $sequence_9 = { 8a0c3b 880e 46 43 ebf3 43 40 }
            // n = 7, score = 200
            //   8a0c3b               | mov                 cl, byte ptr [ebx + edi]
            //   880e                 | mov                 byte ptr [esi], cl
            //   46                   | inc                 esi
            //   43                   | inc                 ebx
            //   ebf3                 | jmp                 0xfffffff5
            //   43                   | inc                 ebx
            //   40                   | inc                 eax

    condition:
        7 of them and filesize < 139264
}