rule win_nitrogen_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nitrogen."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nitrogen"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8905???????? 488b05???????? 48ffc0 488905???????? }
            // n = 4, score = 400
            //   8905????????         |                     
            //   488b05????????       |                     
            //   48ffc0               | dec                 eax
            //   488905????????       |                     

        $sequence_1 = { 4898 488905???????? 8b05???????? 488905???????? }
            // n = 4, score = 400
            //   4898                 | test                eax, eax
            //   488905????????       |                     
            //   8b05????????         |                     
            //   488905????????       |                     

        $sequence_2 = { 488b05???????? 89442454 8b05???????? 89442458 }
            // n = 4, score = 300
            //   488b05????????       |                     
            //   89442454             | cwde                
            //   8b05????????         |                     
            //   89442458             | dec                 eax

        $sequence_3 = { 4898 488905???????? 488b05???????? 4885c0 }
            // n = 4, score = 300
            //   4898                 | cwde                
            //   488905????????       |                     
            //   488b05????????       |                     
            //   4885c0               | dec                 eax

        $sequence_4 = { 0fbe05???????? c1e002 4898 488905???????? }
            // n = 4, score = 300
            //   0fbe05????????       |                     
            //   c1e002               | dec                 eax
            //   4898                 | cwde                
            //   488905????????       |                     

        $sequence_5 = { 668905???????? 488b05???????? 48ffc8 488905???????? }
            // n = 4, score = 300
            //   668905????????       |                     
            //   488b05????????       |                     
            //   48ffc8               | test                eax, eax
            //   488905????????       |                     

        $sequence_6 = { 668905???????? 8b05???????? 668905???????? 8b05???????? }
            // n = 4, score = 300
            //   668905????????       |                     
            //   8b05????????         |                     
            //   668905????????       |                     
            //   8b05????????         |                     

        $sequence_7 = { eb35 488b05???????? 4885c0 7429 }
            // n = 4, score = 300
            //   eb35                 | dec                 eax
            //   488b05????????       |                     
            //   4885c0               | movsx               eax, al
            //   7429                 | dec                 eax

        $sequence_8 = { 8b05???????? ffc0 8905???????? 0fb705???????? }
            // n = 4, score = 300
            //   8b05????????         |                     
            //   ffc0                 | dec                 eax
            //   8905????????         |                     
            //   0fb705????????       |                     

        $sequence_9 = { 668905???????? 8b05???????? ffc8 8905???????? }
            // n = 4, score = 300
            //   668905????????       |                     
            //   8b05????????         |                     
            //   ffc8                 | movzx               eax, ax
            //   8905????????         |                     

        $sequence_10 = { 0fb6c0 8905???????? 8b05???????? 85c0 }
            // n = 4, score = 300
            //   0fb6c0               | cwde                
            //   8905????????         |                     
            //   8b05????????         |                     
            //   85c0                 | dec                 eax

        $sequence_11 = { 8905???????? 488b05???????? 480faf05???????? 488905???????? }
            // n = 4, score = 300
            //   8905????????         |                     
            //   488b05????????       |                     
            //   480faf05????????     |                     
            //   488905????????       |                     

    condition:
        7 of them and filesize < 135349248
}