rule win_nitrogen_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nitrogen_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nitrogen_ransomware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f26c 4183c405 66410f6ed8 4183f569 8b8c2470030000 4183f46c 660f6eca }
            // n = 7, score = 100
            //   83f26c               | xor                 eax, 0x65
            //   4183c405             | mov                 word ptr [esp + 0x17a], ax
            //   66410f6ed8           | movzx               eax, word ptr [esp + 0xb4]
            //   4183f569             | xor                 eax, 0x47
            //   8b8c2470030000       | mov                 word ptr [esp + 0x8078], ax
            //   4183f46c             | lea                 eax, [edx + 0x1d]
            //   660f6eca             | pxor                xmm0, xmm1

        $sequence_1 = { 83c004 31d0 66898424bc020000 0fb79424be020000 8b8424b0020000 83c005 31d0 }
            // n = 7, score = 100
            //   83c004               | xor                 eax, ecx
            //   31d0                 | mov                 word ptr [esp + 0x1b06], ax
            //   66898424bc020000     | inc                 esp
            //   0fb79424be020000     | movzx               ecx, word ptr [esp + 0x1b08]
            //   8b8424b0020000       | mov                 eax, dword ptr [esp + 0x1b00]
            //   83c005               | add                 eax, 2
            //   31d0                 | inc                 esp

        $sequence_2 = { 66898424ae240000 0fb79424b0240000 8b8424a0240000 83c006 31d0 66898424b0240000 0fb79424b2240000 }
            // n = 7, score = 100
            //   66898424ae240000     | mov                 eax, dword ptr [esp + 0x1580]
            //   0fb79424b0240000     | add                 eax, 7
            //   8b8424a0240000       | xor                 eax, edx
            //   83c006               | mov                 word ptr [esp + 0x1592], ax
            //   31d0                 | movzx               edx, word ptr [esp + 0x1594]
            //   66898424b0240000     | mov                 word ptr [esp + 0x1690], ax
            //   0fb79424b2240000     | inc                 esp

        $sequence_3 = { 4189c3 8b8424a06a0000 83c01b 663305???????? 89c3 8b8424a06a0000 83c01c }
            // n = 7, score = 100
            //   4189c3               | or                  eax, eax
            //   8b8424a06a0000       | inc                 cx
            //   83c01b               | movd                mm3, ebx
            //   663305????????       |                     
            //   89c3                 | inc                 esp
            //   8b8424a06a0000       | movzx               eax, word ptr [esp + 0x34]
            //   83c01c               | add                 esi, 0x16

        $sequence_4 = { 83c20d 8944247c 8b8424204f0000 83f274 89442478 8b8424204f0000 89442474 }
            // n = 7, score = 100
            //   83c20d               | mov                 byte ptr [esp + 0x12f], al
            //   8944247c             | mov                 eax, 0x26
            //   8b8424204f0000       | nop                 dword ptr [eax]
            //   83f274               | add                 eax, 0x45
            //   89442478             | mov                 word ptr [esp + 0x3c], ax
            //   8b8424204f0000       | mov                 eax, dword ptr [esp + 0x560]
            //   89442474             | add                 eax, 0x46

        $sequence_5 = { 89442428 660fc4cf01 448b8424702a0000 66450fc4cb01 894c2424 4183c107 66410f62c9 }
            // n = 7, score = 100
            //   89442428             | test                eax, eax
            //   660fc4cf01           | je                  0x17d2
            //   448b8424702a0000     | dec                 eax
            //   66450fc4cb01         | mov                 eax, dword ptr [esp + 0x148]
            //   894c2424             | dec                 eax
            //   4183c107             | test                eax, eax
            //   66410f62c9           | jne                 0x1f40

        $sequence_6 = { 83f065 668984247a400000 0fb7442420 83c00e 83f072 668984247c400000 31c0 }
            // n = 7, score = 100
            //   83f065               | add                 eax, 1
            //   668984247a400000     | dec                 eax
            //   0fb7442420           | cmp                 eax, 0x17
            //   83c00e               | jne                 0x70
            //   83f072               | dec                 eax
            //   668984247c400000     | lea                 eax, [esp + 0x2100]
            //   31c0                 | sub                 edx, 4

        $sequence_7 = { 440fb73d???????? 0f118c24d0650000 8d680a 0fb705???????? 418d4f0a 440fb73d???????? 8d780a }
            // n = 7, score = 100
            //   440fb73d????????     |                     
            //   0f118c24d0650000     | inc                 ecx
            //   8d680a               | lea                 eax, [esp + 1]
            //   0fb705????????       |                     
            //   418d4f0a             | movq                qword ptr [esp + 0x17e], xmm0
            //   440fb73d????????     |                     
            //   8d780a               | movdqu              xmm4, xmmword ptr [esp + 0x170]

        $sequence_8 = { 6689bc24900a0000 0fb77c245e 6689bc24920a0000 6689b424940a0000 f30f6fac24400a0000 f30f6fa424700a0000 66899c24960a0000 }
            // n = 7, score = 100
            //   6689bc24900a0000     | add                 eax, 4
            //   0fb77c245e           | inc                 ecx
            //   6689bc24920a0000     | add                 esp, 5
            //   6689b424940a0000     | inc                 cx
            //   f30f6fac24400a0000     | movd    mm2, eax
            //   f30f6fa424700a0000     | dec    eax
            //   66899c24960a0000     | shl                 eax, 0x10

        $sequence_9 = { ff15???????? 8b542440 4889d9 83ca04 ff15???????? 90 4883c468 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b542440             | mov                 dword ptr [esp + 0x9a0], eax
            //   4889d9               | dec                 eax
            //   83ca04               | mov                 eax, 0x6c0049
            //   ff15????????         |                     
            //   90                   | outsd               dx, dword ptr [esi]
            //   4883c468             | add                 byte ptr [eax], ch

    condition:
        7 of them and filesize < 2590720
}