rule win_no_justice_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.no_justice."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.no_justice"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7720 0fb680ac5c4000 ff2485985c4000 33c0 40 5d }
            // n = 6, score = 100
            //   7720                 | ja                  0x22
            //   0fb680ac5c4000       | movzx               eax, byte ptr [eax + 0x405cac]
            //   ff2485985c4000       | jmp                 dword ptr [eax*4 + 0x405c98]
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5d                   | pop                 ebp

        $sequence_1 = { 8a0a 884c382e 8b45bc 8b048570be4100 804c382d04 }
            // n = 5, score = 100
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884c382e             | mov                 byte ptr [eax + edi + 0x2e], cl
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   8b048570be4100       | mov                 eax, dword ptr [eax*4 + 0x41be70]
            //   804c382d04           | or                  byte ptr [eax + edi + 0x2d], 4

        $sequence_2 = { 0f84e8000000 8b04952c6b4100 898588f8ffff 85c0 0f84ad000000 3bc3 0f84cb000000 }
            // n = 7, score = 100
            //   0f84e8000000         | je                  0xee
            //   8b04952c6b4100       | mov                 eax, dword ptr [edx*4 + 0x416b2c]
            //   898588f8ffff         | mov                 dword ptr [ebp - 0x778], eax
            //   85c0                 | test                eax, eax
            //   0f84ad000000         | je                  0xb3
            //   3bc3                 | cmp                 eax, ebx
            //   0f84cb000000         | je                  0xd1

        $sequence_3 = { e8???????? c9 c3 c705????????08b14100 b001 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   c705????????08b14100     |     
            //   b001                 | mov                 al, 1

        $sequence_4 = { c1e002 50 8b85a8f8ffff 0fb70485946a4100 8d048590614100 50 8d8590faffff }
            // n = 7, score = 100
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   8b85a8f8ffff         | mov                 eax, dword ptr [ebp - 0x758]
            //   0fb70485946a4100     | movzx               eax, word ptr [eax*4 + 0x416a94]
            //   8d048590614100       | lea                 eax, [eax*4 + 0x416190]
            //   50                   | push                eax
            //   8d8590faffff         | lea                 eax, [ebp - 0x570]

        $sequence_5 = { 8b148d70be4100 0355b0 8a0c03 03d3 43 }
            // n = 5, score = 100
            //   8b148d70be4100       | mov                 edx, dword ptr [ecx*4 + 0x41be70]
            //   0355b0               | add                 edx, dword ptr [ebp - 0x50]
            //   8a0c03               | mov                 cl, byte ptr [ebx + eax]
            //   03d3                 | add                 edx, ebx
            //   43                   | inc                 ebx

        $sequence_6 = { c745e003000000 c745e4508e4100 e9???????? 83e80f }
            // n = 4, score = 100
            //   c745e003000000       | mov                 dword ptr [ebp - 0x20], 3
            //   c745e4508e4100       | mov                 dword ptr [ebp - 0x1c], 0x418e50
            //   e9????????           |                     
            //   83e80f               | sub                 eax, 0xf

        $sequence_7 = { 57 e8???????? 59 59 e9???????? 8b049570be4100 f644082840 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   8b049570be4100       | mov                 eax, dword ptr [edx*4 + 0x41be70]
            //   f644082840           | test                byte ptr [eax + ecx + 0x28], 0x40

        $sequence_8 = { f7d0 a801 74a5 8b55ec 33f6 8b049570be4100 }
            // n = 6, score = 100
            //   f7d0                 | not                 eax
            //   a801                 | test                al, 1
            //   74a5                 | je                  0xffffffa7
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   33f6                 | xor                 esi, esi
            //   8b049570be4100       | mov                 eax, dword ptr [edx*4 + 0x41be70]

        $sequence_9 = { 0f8414020000 eb4f 0fb602 0fbe8860b74100 41 894db4 3bcf }
            // n = 7, score = 100
            //   0f8414020000         | je                  0x21a
            //   eb4f                 | jmp                 0x51
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   0fbe8860b74100       | movsx               ecx, byte ptr [eax + 0x41b760]
            //   41                   | inc                 ecx
            //   894db4               | mov                 dword ptr [ebp - 0x4c], ecx
            //   3bcf                 | cmp                 ecx, edi

    condition:
        7 of them and filesize < 253952
}