rule win_nocturnalstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nocturnalstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nocturnalstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? bd01000000 81c717a0fb5f 01ef 81ef17a0fb5f 5d 81e7cfaad32f }
            // n = 7, score = 100
            //   e9????????           |                     
            //   bd01000000           | mov                 ebp, 1
            //   81c717a0fb5f         | add                 edi, 0x5ffba017
            //   01ef                 | add                 edi, ebp
            //   81ef17a0fb5f         | sub                 edi, 0x5ffba017
            //   5d                   | pop                 ebp
            //   81e7cfaad32f         | and                 edi, 0x2fd3aacf

        $sequence_1 = { d280e1f107c3 7dbf 41 6c 46 3f a984011afd }
            // n = 7, score = 100
            //   d280e1f107c3         | rol                 byte ptr [eax - 0x3cf80e1f], cl
            //   7dbf                 | jge                 0xffffffc1
            //   41                   | inc                 ecx
            //   6c                   | insb                byte ptr es:[edi], dx
            //   46                   | inc                 esi
            //   3f                   | aas                 
            //   a984011afd           | test                eax, 0xfd1a0184

        $sequence_2 = { e9???????? 51 b9dd9abe6f 31c8 59 05f1eb6f2f 05b354dc74 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   51                   | push                ecx
            //   b9dd9abe6f           | mov                 ecx, 0x6fbe9add
            //   31c8                 | xor                 eax, ecx
            //   59                   | pop                 ecx
            //   05f1eb6f2f           | add                 eax, 0x2f6febf1
            //   05b354dc74           | add                 eax, 0x74dc54b3

        $sequence_3 = { e9???????? bb74bcf36f f7d3 4b 81cb108dfb7b 81e337e4f765 55 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   bb74bcf36f           | mov                 ebx, 0x6ff3bc74
            //   f7d3                 | not                 ebx
            //   4b                   | dec                 ebx
            //   81cb108dfb7b         | or                  ebx, 0x7bfb8d10
            //   81e337e4f765         | and                 ebx, 0x65f7e437
            //   55                   | push                ebp

        $sequence_4 = { c70424009d1a20 891424 ba77a7ee3f 89d3 8b1424 53 89e3 }
            // n = 7, score = 100
            //   c70424009d1a20       | mov                 dword ptr [esp], 0x201a9d00
            //   891424               | mov                 dword ptr [esp], edx
            //   ba77a7ee3f           | mov                 edx, 0x3feea777
            //   89d3                 | mov                 ebx, edx
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   53                   | push                ebx
            //   89e3                 | mov                 ebx, esp

        $sequence_5 = { e9???????? 58 81c404000000 e9???????? 81f6d544f73f 58 81eb4703df3d }
            // n = 7, score = 100
            //   e9????????           |                     
            //   58                   | pop                 eax
            //   81c404000000         | add                 esp, 4
            //   e9????????           |                     
            //   81f6d544f73f         | xor                 esi, 0x3ff744d5
            //   58                   | pop                 eax
            //   81eb4703df3d         | sub                 ebx, 0x3ddf0347

        $sequence_6 = { ff3424 8b0c24 57 e9???????? 58 051ff53d3f 01c6 }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   57                   | push                edi
            //   e9????????           |                     
            //   58                   | pop                 eax
            //   051ff53d3f           | add                 eax, 0x3f3df51f
            //   01c6                 | add                 esi, eax

        $sequence_7 = { f7d0 2d612e2f1b 053325461d 89c2 58 01542404 5a }
            // n = 7, score = 100
            //   f7d0                 | not                 eax
            //   2d612e2f1b           | sub                 eax, 0x1b2f2e61
            //   053325461d           | add                 eax, 0x1d462533
            //   89c2                 | mov                 edx, eax
            //   58                   | pop                 eax
            //   01542404             | add                 dword ptr [esp + 4], edx
            //   5a                   | pop                 edx

        $sequence_8 = { e9???????? 8365d800 c745dcfedf4900 a1???????? 8d4dd8 33c1 8945e0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8365d800             | and                 dword ptr [ebp - 0x28], 0
            //   c745dcfedf4900       | mov                 dword ptr [ebp - 0x24], 0x49dffe
            //   a1????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   33c1                 | xor                 eax, ecx
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_9 = { e9???????? 81f2209cfd37 81eaf4ffef7d 81c2d90dace9 e9???????? 890c24 812c2439bc9f73 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81f2209cfd37         | xor                 edx, 0x37fd9c20
            //   81eaf4ffef7d         | sub                 edx, 0x7deffff4
            //   81c2d90dace9         | add                 edx, 0xe9ac0dd9
            //   e9????????           |                     
            //   890c24               | mov                 dword ptr [esp], ecx
            //   812c2439bc9f73       | sub                 dword ptr [esp], 0x739fbc39

    condition:
        7 of them and filesize < 10739712
}