rule win_nokoyawa_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nokoyawa."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nokoyawa"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88040a 8b442420 83c010 4898 8b4c2420 83c12c 4863c9 }
            // n = 7, score = 100
            //   88040a               | dec                 eax
            //   8b442420             | mov                 edx, dword ptr [esp + 0xc0]
            //   83c010               | dec                 eax
            //   4898                 | add                 edx, ecx
            //   8b4c2420             | dec                 eax
            //   83c12c               | mov                 ecx, edx
            //   4863c9               | mov                 edx, dword ptr [esp + eax*4 + 0x30]

        $sequence_1 = { e8???????? 488905???????? c744243000000000 eb0a 8b442430 ffc0 89442430 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488905????????       |                     
            //   c744243000000000     | dec                 eax
            //   eb0a                 | mov                 eax, ecx
            //   8b442430             | dec                 eax
            //   ffc0                 | mov                 dword ptr [esp + 0x68], eax
            //   89442430             | dec                 eax

        $sequence_2 = { 89448c30 4863442420 8b4c2420 c1e102 }
            // n = 4, score = 100
            //   89448c30             | dec                 eax
            //   4863442420           | lea                 edx, [0x645b]
            //   8b4c2420             | dec                 eax
            //   c1e102               | lea                 ecx, [esp + 0x8b0]

        $sequence_3 = { c1e01e 8b4c2408 c1e902 0bc1 89442408 33c0 85c0 }
            // n = 7, score = 100
            //   c1e01e               | mov                 eax, dword ptr [esp + eax + 0x20]
            //   8b4c2408             | xor                 eax, ecx
            //   c1e902               | mov                 ecx, 4
            //   0bc1                 | dec                 eax
            //   89442408             | imul                ecx, ecx, 7
            //   33c0                 | xor                 eax, dword ptr [esp + ecx + 0x20]
            //   85c0                 | dec                 eax

        $sequence_4 = { 33d2 488b442430 488b4850 e8???????? }
            // n = 4, score = 100
            //   33d2                 | xor                 eax, dword ptr [esp + ecx + 0x20]
            //   488b442430           | mov                 ecx, 4
            //   488b4850             | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 8bca 8b942438010000 03d1 8bca 8d84089979825a 8b4c2410 }
            // n = 6, score = 100
            //   8bca                 | dec                 eax
            //   8b942438010000       | sub                 eax, 4
            //   03d1                 | dec                 eax
            //   8bca                 | add                 eax, 0x20
            //   8d84089979825a       | dec                 eax
            //   8b4c2410             | mov                 edx, eax

        $sequence_6 = { 85c0 7411 488b542468 488b4c2460 e8???????? eb0a 488b4c2460 }
            // n = 7, score = 100
            //   85c0                 | mov                 dword ptr [esp + 0x20], eax
            //   7411                 | mov                 edx, 0x40
            //   488b542468           | dec                 eax
            //   488b4c2460           | lea                 ecx, [esp + 0x50]
            //   e8????????           |                     
            //   eb0a                 | dec                 esp
            //   488b4c2460           | lea                 eax, [esp + 0x130]

        $sequence_7 = { 486bc000 488b4c2440 8b542420 39540114 7326 b804000000 486bc001 }
            // n = 7, score = 100
            //   486bc000             | and                 eax, 0xffffffc0
            //   488b4c2440           | mov                 eax, eax
            //   8b542420             | dec                 eax
            //   39540114             | mov                 ecx, dword ptr [esp + 0x70]
            //   7326                 | jl                  0x1ab4
            //   b804000000           | movzx               eax, byte ptr [esp]
            //   486bc001             | sub                 eax, 0x20

        $sequence_8 = { e8???????? 85c0 742a 4c8b8c24c8000000 4c8b8424c0000000 488b9424b8000000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | add                 ecx, 8
            //   742a                 | dec                 eax
            //   4c8b8c24c8000000     | mov                 ecx, dword ptr [esp + 0x40]
            //   4c8b8424c0000000     | mov                 ecx, dword ptr [ecx + 0xc]
            //   488b9424b8000000     | and                 ecx, 0xff00

        $sequence_9 = { c644242b61 c644242c6e c644242d64 c644242e20 c644242f31 c644243036 c64424312d }
            // n = 7, score = 100
            //   c644242b61           | dec                 eax
            //   c644242c6e           | mov                 ecx, dword ptr [esp + 0x60]
            //   c644242d64           | mov                 dword ptr [esp + 0x48], eax
            //   c644242e20           | mov                 eax, dword ptr [esp + 0x48]
            //   c644242f31           | add                 eax, 2
            //   c644243036           | xor                 edx, edx
            //   c64424312d           | dec                 eax

    condition:
        7 of them and filesize < 92160
}