rule win_norobot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.norobot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.norobot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6400800 488b442408 c3 48894c2408 4883ec28 488b442430 488bc8 }
            // n = 7, score = 100
            //   c6400800             | dec                 eax
            //   488b442408           | mov                 ecx, dword ptr [esp + 0x60]
            //   c3                   | dec                 eax
            //   48894c2408           | mov                 dword ptr [esp + 8], ecx
            //   4883ec28             | dec                 eax
            //   488b442430           | sub                 esp, 0x48
            //   488bc8               | dec                 eax

        $sequence_1 = { 4883c420 5b c3 4883611000 488d0520b20100 48894108 488d0505b20100 }
            // n = 7, score = 100
            //   4883c420             | mov                 eax, ecx
            //   5b                   | mov                 eax, 0x5a4d
            //   c3                   | cmp                 word ptr [0xffff4df9], ax
            //   4883611000           | jne                 0x1bbd
            //   488d0520b20100       | dec                 eax
            //   48894108             | arpl                word ptr [0xffff4e2c], cx
            //   488d0505b20100       | dec                 eax

        $sequence_2 = { 4d3bc4 0f84ba000000 8b7500 498b9cf620c60300 90 4885db 740e }
            // n = 7, score = 100
            //   4d3bc4               | mov                 ecx, dword ptr [edi]
            //   0f84ba000000         | dec                 esp
            //   8b7500               | mov                 eax, ebp
            //   498b9cf620c60300     | dec                 eax
            //   90                   | mov                 edx, ebx
            //   4885db               | test                eax, eax
            //   740e                 | inc                 ecx

        $sequence_3 = { 4883ec68 488b05???????? 4833c4 4889442450 4883bc248000000000 7f07 }
            // n = 6, score = 100
            //   4883ec68             | dec                 esp
            //   488b05????????       |                     
            //   4833c4               | lea                 ecx, [0xc145]
            //   4889442450           | vmulsd              xmm0, xmm1, xmm1
            //   4883bc248000000000     | dec    esp
            //   7f07                 | lea                 ecx, [0x1194d]

        $sequence_4 = { 4c8d4c2428 4c8d442430 488bd0 488b4c2450 e8???????? 488b442450 }
            // n = 6, score = 100
            //   4c8d4c2428           | dec                 esp
            //   4c8d442430           | lea                 eax, [esp + 0x74]
            //   488bd0               | mov                 edx, 0x1f
            //   488b4c2450           | dec                 eax
            //   e8????????           |                     
            //   488b442450           | cmp                 dword ptr [esp + 0x40], 0

        $sequence_5 = { 4883bc248800000000 0f8482000000 33c0 83f801 }
            // n = 4, score = 100
            //   4883bc248800000000     | inc    esp
            //   0f8482000000         | lea                 ecx, [eax + 1]
            //   33c0                 | dec                 esp
            //   83f801               | lea                 eax, [0x11e98]

        $sequence_6 = { 4c8d0576750000 41f644400201 7405 0fb6c9 eb25 0fb6d1 }
            // n = 6, score = 100
            //   4c8d0576750000       | dec                 eax
            //   41f644400201         | cmp                 ecx, eax
            //   7405                 | jae                 0xfe0
            //   0fb6c9               | mov                 ecx, dword ptr [esp + 0xc8]
            //   eb25                 | mov                 byte ptr [esp + 0x40], al
            //   0fb6d1               | dec                 eax

        $sequence_7 = { 7536 488d15db130300 488b8c24c0100000 e8???????? 8b442440 83c801 89442440 }
            // n = 7, score = 100
            //   7536                 | cmp                 dword ptr [ecx + 0x150], edi
            //   488d15db130300       | jne                 0x1e98
            //   488b8c24c0100000     | dec                 eax
            //   e8????????           |                     
            //   8b442440             | lea                 ebx, [0xb4e8]
            //   83c801               | jmp                 0x1ee9
            //   89442440             | mov                 edx, 0x2c0

        $sequence_8 = { 4c8d057b1a0100 488d157c1a0100 b912000000 e8???????? 4885c0 741d 49ba7073d836192e55f3 }
            // n = 7, score = 100
            //   4c8d057b1a0100       | inc                 ecx
            //   488d157c1a0100       | mov                 dword ptr [edx + 0x18], ecx
            //   b912000000           | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 edx, dword ptr [edx]
            //   741d                 | movzx               ecx, byte ptr [edx]
            //   49ba7073d836192e55f3     | and    ecx, 0xf

        $sequence_9 = { e8???????? 0fb6c0 85c0 7448 48837c245000 7507 837c245801 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb6c0               | dec                 eax
            //   85c0                 | mov                 dword ptr [eax + 0x38], 0
            //   7448                 | dec                 eax
            //   48837c245000         | mov                 eax, dword ptr [esp + 0x40]
            //   7507                 | dec                 eax
            //   837c245801           | mov                 dword ptr [eax + 0x40], 0

    condition:
        7 of them and filesize < 545792
}