rule win_nozelesn_decryptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nozelesn_decryptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nozelesn_decryptor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1c20d 33f0 8bca 33f2 c1e103 33c8 d1c6 }
            // n = 7, score = 100
            //   c1c20d               | rol                 edx, 0xd
            //   33f0                 | xor                 esi, eax
            //   8bca                 | mov                 ecx, edx
            //   33f2                 | xor                 esi, edx
            //   c1e103               | shl                 ecx, 3
            //   33c8                 | xor                 ecx, eax
            //   d1c6                 | rol                 esi, 1

        $sequence_1 = { 8bff 55 8bec 8b4d08 33c0 3b0cc5a8574600 7427 }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   3b0cc5a8574600       | cmp                 ecx, dword ptr [eax*8 + 0x4657a8]
            //   7427                 | je                  0x29

        $sequence_2 = { 80f939 7510 c60630 8b8578ffffff 4e 3bf0 75e0 }
            // n = 7, score = 100
            //   80f939               | cmp                 cl, 0x39
            //   7510                 | jne                 0x12
            //   c60630               | mov                 byte ptr [esi], 0x30
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]
            //   4e                   | dec                 esi
            //   3bf0                 | cmp                 esi, eax
            //   75e0                 | jne                 0xffffffe2

        $sequence_3 = { 0f8742010000 eb14 8b7d80 83c002 8b75b4 8b8d7cffffff e9???????? }
            // n = 7, score = 100
            //   0f8742010000         | ja                  0x148
            //   eb14                 | jmp                 0x16
            //   8b7d80               | mov                 edi, dword ptr [ebp - 0x80]
            //   83c002               | add                 eax, 2
            //   8b75b4               | mov                 esi, dword ptr [ebp - 0x4c]
            //   8b8d7cffffff         | mov                 ecx, dword ptr [ebp - 0x84]
            //   e9????????           |                     

        $sequence_4 = { 8b450c 8b5508 8bca c745e800000000 c745ec0f000000 8b38 }
            // n = 6, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8bca                 | mov                 ecx, edx
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf
            //   8b38                 | mov                 edi, dword ptr [eax]

        $sequence_5 = { 53 8b5d10 56 57 8bf9 33f6 8b07 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   33f6                 | xor                 esi, esi
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_6 = { 89bd78ffffff 47 897d8c 813900ca9a3b 88559f 0f95c0 895588 }
            // n = 7, score = 100
            //   89bd78ffffff         | mov                 dword ptr [ebp - 0x88], edi
            //   47                   | inc                 edi
            //   897d8c               | mov                 dword ptr [ebp - 0x74], edi
            //   813900ca9a3b         | cmp                 dword ptr [ecx], 0x3b9aca00
            //   88559f               | mov                 byte ptr [ebp - 0x61], dl
            //   0f95c0               | setne               al
            //   895588               | mov                 dword ptr [ebp - 0x78], edx

        $sequence_7 = { 8bfb 335df8 f7d7 8b4df8 0bd8 f7d1 }
            // n = 6, score = 100
            //   8bfb                 | mov                 edi, ebx
            //   335df8               | xor                 ebx, dword ptr [ebp - 8]
            //   f7d7                 | not                 edi
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   0bd8                 | or                  ebx, eax
            //   f7d1                 | not                 ecx

        $sequence_8 = { c745e428664200 eb08 8d4dd8 e8???????? 837e1808 }
            // n = 5, score = 100
            //   c745e428664200       | mov                 dword ptr [ebp - 0x1c], 0x426628
            //   eb08                 | jmp                 0xa
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   837e1808             | cmp                 dword ptr [esi + 0x18], 8

        $sequence_9 = { 837de800 894da0 894d90 7653 8b03 8d4dc0 51 }
            // n = 7, score = 100
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   894da0               | mov                 dword ptr [ebp - 0x60], ecx
            //   894d90               | mov                 dword ptr [ebp - 0x70], ecx
            //   7653                 | jbe                 0x55
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 1122304
}