rule win_nullmixer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nullmixer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nullmixer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85f6 0f8ed1000000 894c2418 8b7b68 c1e603 31d2 895c241c }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   0f8ed1000000         | jle                 0xd7
            //   894c2418             | mov                 dword ptr [esp + 0x18], ecx
            //   8b7b68               | mov                 edi, dword ptr [ebx + 0x68]
            //   c1e603               | shl                 esi, 3
            //   31d2                 | xor                 edx, edx
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx

        $sequence_1 = { e9???????? 8b4500 89e9 ff5028 8b442418 8b7c2454 8b5804 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   89e9                 | mov                 ecx, ebp
            //   ff5028               | call                dword ptr [eax + 0x28]
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b7c2454             | mov                 edi, dword ptr [esp + 0x54]
            //   8b5804               | mov                 ebx, dword ptr [eax + 4]

        $sequence_2 = { 89ce 0f8586010000 38d0 0f84b9010000 0fb7442464 8b4c2460 6683f8ff }
            // n = 7, score = 100
            //   89ce                 | mov                 esi, ecx
            //   0f8586010000         | jne                 0x18c
            //   38d0                 | cmp                 al, dl
            //   0f84b9010000         | je                  0x1bf
            //   0fb7442464           | movzx               eax, word ptr [esp + 0x64]
            //   8b4c2460             | mov                 ecx, dword ptr [esp + 0x60]
            //   6683f8ff             | cmp                 ax, -1

        $sequence_3 = { 8b45bc 85c0 0f8536020000 807dc001 0f842c020000 8b4520 31c9 }
            // n = 7, score = 100
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   85c0                 | test                eax, eax
            //   0f8536020000         | jne                 0x23c
            //   807dc001             | cmp                 byte ptr [ebp - 0x40], 1
            //   0f842c020000         | je                  0x232
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   31c9                 | xor                 ecx, ecx

        $sequence_4 = { 83ec08 0fb6442420 8b7c2428 c7042400000000 8b542430 88442407 8b442424 }
            // n = 7, score = 100
            //   83ec08               | sub                 esp, 8
            //   0fb6442420           | movzx               eax, byte ptr [esp + 0x20]
            //   8b7c2428             | mov                 edi, dword ptr [esp + 0x28]
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   88442407             | mov                 byte ptr [esp + 7], al
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]

        $sequence_5 = { e8???????? 8b44243c b925000000 8b10 8b5218 81fa???????? 0f842bffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   b925000000           | mov                 ecx, 0x25
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b5218               | mov                 edx, dword ptr [edx + 0x18]
            //   81fa????????         |                     
            //   0f842bffffff         | je                  0xffffff31

        $sequence_6 = { ff5210 0fbe17 89e9 89c3 8b4500 83ec04 891424 }
            // n = 7, score = 100
            //   ff5210               | call                dword ptr [edx + 0x10]
            //   0fbe17               | movsx               edx, byte ptr [edi]
            //   89e9                 | mov                 ecx, ebp
            //   89c3                 | mov                 ebx, eax
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   83ec04               | sub                 esp, 4
            //   891424               | mov                 dword ptr [esp], edx

        $sequence_7 = { e8???????? b902000000 89c6 89c3 f3a6 0f97c0 1c00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b902000000           | mov                 ecx, 2
            //   89c6                 | mov                 esi, eax
            //   89c3                 | mov                 ebx, eax
            //   f3a6                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]
            //   0f97c0               | seta                al
            //   1c00                 | sbb                 al, 0

        $sequence_8 = { 0f85baf9ffff 0fb7550c 8d4508 e8???????? 89c3 0fb64610 e9???????? }
            // n = 7, score = 100
            //   0f85baf9ffff         | jne                 0xfffff9c0
            //   0fb7550c             | movzx               edx, word ptr [ebp + 0xc]
            //   8d4508               | lea                 eax, [ebp + 8]
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   0fb64610             | movzx               eax, byte ptr [esi + 0x10]
            //   e9????????           |                     

        $sequence_9 = { 8b842488000000 8b942494000000 8b00 894c2404 8954240c 8b8c2480000000 8b942490000000 }
            // n = 7, score = 100
            //   8b842488000000       | mov                 eax, dword ptr [esp + 0x88]
            //   8b942494000000       | mov                 edx, dword ptr [esp + 0x94]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   8b8c2480000000       | mov                 ecx, dword ptr [esp + 0x80]
            //   8b942490000000       | mov                 edx, dword ptr [esp + 0x90]

    condition:
        7 of them and filesize < 2351104
}