rule win_obscene_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.obscene."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.obscene"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6a00 6a00 ff15???????? eb09 }
            // n = 5, score = 100
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   eb09                 | jmp                 0xb

        $sequence_1 = { ff75f0 ff15???????? 50 68c03d1010 e8???????? }
            // n = 5, score = 100
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   68c03d1010           | push                0x10103dc0
            //   e8????????           |                     

        $sequence_2 = { 0fbe00 83f830 7c0b 8b45f8 }
            // n = 4, score = 100
            //   0fbe00               | movsx               eax, byte ptr [eax]
            //   83f830               | cmp                 eax, 0x30
            //   7c0b                 | jl                  0xd
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_3 = { 6828431010 68e4401010 e8???????? 59 59 682c431010 }
            // n = 6, score = 100
            //   6828431010           | push                0x10104328
            //   68e4401010           | push                0x101040e4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   682c431010           | push                0x1010432c

        $sequence_4 = { 6a06 68???????? ff35???????? 6aff ff15???????? 68???????? }
            // n = 6, score = 100
            //   6a06                 | push                6
            //   68????????           |                     
            //   ff35????????         |                     
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_5 = { eb61 68???????? 68???????? 68???????? e8???????? 83c40c 68???????? }
            // n = 7, score = 100
            //   eb61                 | jmp                 0x63
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     

        $sequence_6 = { ff750c e8???????? 59 3da0bb0d00 733e ff75fc 6800080000 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   3da0bb0d00           | cmp                 eax, 0xdbba0
            //   733e                 | jae                 0x40
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6800080000           | push                0x800

        $sequence_7 = { 59 ff7508 6860ad0010 e8???????? 59 59 68bc501010 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6860ad0010           | push                0x1000ad60
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   68bc501010           | push                0x101050bc

        $sequence_8 = { c605????????68 c705????????d15aaa00 c605????????c3 8d45fc 50 6a06 }
            // n = 6, score = 100
            //   c605????????68       |                     
            //   c705????????d15aaa00     |     
            //   c605????????c3       |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a06                 | push                6

        $sequence_9 = { 55 8bec 81ec04080000 68???????? ff750c e8???????? 59 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec04080000         | sub                 esp, 0x804
            //   68????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 2170880
}