rule win_october_seventh_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.october_seventh."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.october_seventh"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81784870034200 7409 ff7048 e8???????? 59 8b45fc }
            // n = 6, score = 100
            //   81784870034200       | cmp                 dword ptr [eax + 0x48], 0x420370
            //   7409                 | je                  0xb
            //   ff7048               | push                dword ptr [eax + 0x48]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_1 = { 80ba????????3f 76f3 2bcf 49 8d4103 99 }
            // n = 6, score = 100
            //   80ba????????3f       |                     
            //   76f3                 | jbe                 0xfffffff5
            //   2bcf                 | sub                 ecx, edi
            //   49                   | dec                 ecx
            //   8d4103               | lea                 eax, [ecx + 3]
            //   99                   | cdq                 

        $sequence_2 = { 50 8b8598f8ffff 0fb7048544cb4100 8d048540c24100 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8b8598f8ffff         | mov                 eax, dword ptr [ebp - 0x768]
            //   0fb7048544cb4100     | movzx               eax, word ptr [eax*4 + 0x41cb44]
            //   8d048540c24100       | lea                 eax, [eax*4 + 0x41c240]

        $sequence_3 = { ff35???????? 89442410 e8???????? 8bf0 83c408 }
            // n = 5, score = 100
            //   ff35????????         |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8

        $sequence_4 = { 8b0cbdd08fd500 c644112900 837dfc00 7507 b800800000 eb1e 84db }
            // n = 7, score = 100
            //   8b0cbdd08fd500       | mov                 ecx, dword ptr [edi*4 + 0xd58fd0]
            //   c644112900           | mov                 byte ptr [ecx + edx + 0x29], 0
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7507                 | jne                 9
            //   b800800000           | mov                 eax, 0x8000
            //   eb1e                 | jmp                 0x20
            //   84db                 | test                bl, bl

        $sequence_5 = { 8b45d4 0345b4 48 e9???????? 8b0c85d08fd500 }
            // n = 5, score = 100
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   0345b4               | add                 eax, dword ptr [ebp - 0x4c]
            //   48                   | dec                 eax
            //   e9????????           |                     
            //   8b0c85d08fd500       | mov                 ecx, dword ptr [eax*4 + 0xd58fd0]

        $sequence_6 = { 33c0 5b 8be5 5d c3 8b4018 33f6 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]
            //   33f6                 | xor                 esi, esi

        $sequence_7 = { 68???????? a3???????? ffd0 ba???????? b9???????? 8bf0 }
            // n = 6, score = 100
            //   68????????           |                     
            //   a3????????           |                     
            //   ffd0                 | call                eax
            //   ba????????           |                     
            //   b9????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { 7470 eb17 be???????? 68???????? e8???????? 83c404 }
            // n = 6, score = 100
            //   7470                 | je                  0x72
            //   eb17                 | jmp                 0x19
            //   be????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_9 = { 46 3b75f0 72c5 eb0f 8b45f4 8b7dfc 0fb70470 }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   3b75f0               | cmp                 esi, dword ptr [ebp - 0x10]
            //   72c5                 | jb                  0xffffffc7
            //   eb0f                 | jmp                 0x11
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   0fb70470             | movzx               eax, word ptr [eax + esi*2]

    condition:
        7 of them and filesize < 19859456
}