rule win_octopus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.octopus"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 34ae 34ba 34c8 34f0 34fb 3404 3514351c35 }
            // n = 7, score = 100
            //   34ae                 | xor                 al, 0xae
            //   34ba                 | xor                 al, 0xba
            //   34c8                 | xor                 al, 0xc8
            //   34f0                 | xor                 al, 0xf0
            //   34fb                 | xor                 al, 0xfb
            //   3404                 | xor                 al, 4
            //   3514351c35           | xor                 eax, 0x351c3514

        $sequence_1 = { e8???????? 8b45cc e8???????? 8b15???????? e8???????? 8bd8 85db }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   e8????????           |                     
            //   8b15????????         |                     
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_2 = { ff565c 54 6a00 8bc7 }
            // n = 4, score = 100
            //   ff565c               | call                dword ptr [esi + 0x5c]
            //   54                   | push                esp
            //   6a00                 | push                0
            //   8bc7                 | mov                 eax, edi

        $sequence_3 = { 8945e8 8b83b4020000 8945ec ff75ec ff75e8 8d55fc a1???????? }
            // n = 7, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b83b4020000         | mov                 eax, dword ptr [ebx + 0x2b4]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   a1????????           |                     

        $sequence_4 = { f6461c02 7520 0fb6c3 8b048598386b00 83c800 50 }
            // n = 6, score = 100
            //   f6461c02             | test                byte ptr [esi + 0x1c], 2
            //   7520                 | jne                 0x22
            //   0fb6c3               | movzx               eax, bl
            //   8b048598386b00       | mov                 eax, dword ptr [eax*4 + 0x6b3898]
            //   83c800               | or                  eax, 0
            //   50                   | push                eax

        $sequence_5 = { 7448 8b4508 8b40fc 8b10 ff5220 8945fc 8d55f8 }
            // n = 7, score = 100
            //   7448                 | je                  0x4a
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b40fc               | mov                 eax, dword ptr [eax - 4]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5220               | call                dword ptr [edx + 0x20]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d55f8               | lea                 edx, [ebp - 8]

        $sequence_6 = { 8bc7 8b08 ff5160 56 }
            // n = 4, score = 100
            //   8bc7                 | mov                 eax, edi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5160               | call                dword ptr [ecx + 0x60]
            //   56                   | push                esi

        $sequence_7 = { 32f4 321433 2033 44 }
            // n = 4, score = 100
            //   32f4                 | xor                 dh, ah
            //   321433               | xor                 dl, byte ptr [ebx + esi]
            //   2033                 | and                 byte ptr [ebx], dh
            //   44                   | inc                 esp

        $sequence_8 = { e8???????? 8b45f8 8b8054010000 8b15???????? e8???????? 33c0 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b8054010000         | mov                 eax, dword ptr [eax + 0x154]
            //   8b15????????         |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { e8???????? 8b8ac8c40100 33c8 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b8ac8c40100         | mov                 ecx, dword ptr [edx + 0x1c4c8]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     

        $sequence_10 = { 53 8bd8 8893bc020000 33d2 b806000000 e8???????? 84c0 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8bd8                 | mov                 ebx, eax
            //   8893bc020000         | mov                 byte ptr [ebx + 0x2bc], dl
            //   33d2                 | xor                 edx, edx
            //   b806000000           | mov                 eax, 6
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_11 = { 8bd8 0fb6436d 0fb680ec796100 3a4373 }
            // n = 4, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   0fb6436d             | movzx               eax, byte ptr [ebx + 0x6d]
            //   0fb680ec796100       | movzx               eax, byte ptr [eax + 0x6179ec]
            //   3a4373               | cmp                 al, byte ptr [ebx + 0x73]

        $sequence_12 = { 50 0fb64510 8b0485e8376b00 0fb64d0c 0b048df8376b00 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   0fb64510             | movzx               eax, byte ptr [ebp + 0x10]
            //   8b0485e8376b00       | mov                 eax, dword ptr [eax*4 + 0x6b37e8]
            //   0fb64d0c             | movzx               ecx, byte ptr [ebp + 0xc]
            //   0b048df8376b00       | or                  eax, dword ptr [ecx*4 + 0x6b37f8]

        $sequence_13 = { e8???????? 84c0 0f854a010000 8b45f0 8bf0 803800 0f84df020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f854a010000         | jne                 0x150
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8bf0                 | mov                 esi, eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   0f84df020000         | je                  0x2e5

        $sequence_14 = { 741c 8d55fc 8b833c040000 e8???????? 8b55fc 8b83c8030000 e8???????? }
            // n = 7, score = 100
            //   741c                 | je                  0x1e
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   8b833c040000         | mov                 eax, dword ptr [ebx + 0x43c]
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b83c8030000         | mov                 eax, dword ptr [ebx + 0x3c8]
            //   e8????????           |                     

        $sequence_15 = { 8b8564fdffff 8b08 ff513c 33c0 }
            // n = 4, score = 100
            //   8b8564fdffff         | mov                 eax, dword ptr [ebp - 0x29c]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff513c               | call                dword ptr [ecx + 0x3c]
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 7610368
}