rule win_octowave_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.octowave."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.octowave"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { fecb 889c24c0000000 8b9c244c010000 85db 7529 8d9c242c010000 8d7b01 }
            // n = 7, score = 100
            //   fecb                 | dec                 bl
            //   889c24c0000000       | mov                 byte ptr [esp + 0xc0], bl
            //   8b9c244c010000       | mov                 ebx, dword ptr [esp + 0x14c]
            //   85db                 | test                ebx, ebx
            //   7529                 | jne                 0x2b
            //   8d9c242c010000       | lea                 ebx, [esp + 0x12c]
            //   8d7b01               | lea                 edi, [ebx + 1]

        $sequence_1 = { ff86201b0000 8b86201b0000 c684302013000000 83ef01 75d3 8b5c2414 85d2 }
            // n = 7, score = 100
            //   ff86201b0000         | inc                 dword ptr [esi + 0x1b20]
            //   8b86201b0000         | mov                 eax, dword ptr [esi + 0x1b20]
            //   c684302013000000     | mov                 byte ptr [eax + esi + 0x1320], 0
            //   83ef01               | sub                 edi, 1
            //   75d3                 | jne                 0xffffffd5
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   85d2                 | test                edx, edx

        $sequence_2 = { ff742450 56 e8???????? 83c408 85c0 0f850a040000 83cb10 }
            // n = 7, score = 100
            //   ff742450             | push                dword ptr [esp + 0x50]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f850a040000         | jne                 0x410
            //   83cb10               | or                  ebx, 0x10

        $sequence_3 = { 8d4f02 51 56 e8???????? 83c408 5f 8bc6 }
            // n = 7, score = 100
            //   8d4f02               | lea                 ecx, [edi + 2]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { ff742418 2bf5 ff742424 8b04b568022110 ffd0 8b7c241c 83c40c }
            // n = 7, score = 100
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   2bf5                 | sub                 esi, ebp
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   8b04b568022110       | mov                 eax, dword ptr [esi*4 + 0x10210268]
            //   ffd0                 | call                eax
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { ff7500 50 e8???????? 83c408 837db800 750a f30f1015???????? }
            // n = 7, score = 100
            //   ff7500               | push                dword ptr [ebp]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   837db800             | cmp                 dword ptr [ebp - 0x48], 0
            //   750a                 | jne                 0xc
            //   f30f1015????????     |                     

        $sequence_6 = { f30f5cc8 f30f1041e8 f30f594714 f30f5cc8 f30f1041e4 f30f594718 f30f5cc8 }
            // n = 7, score = 100
            //   f30f5cc8             | subss               xmm1, xmm0
            //   f30f1041e8           | movss               xmm0, dword ptr [ecx - 0x18]
            //   f30f594714           | mulss               xmm0, dword ptr [edi + 0x14]
            //   f30f5cc8             | subss               xmm1, xmm0
            //   f30f1041e4           | movss               xmm0, dword ptr [ecx - 0x1c]
            //   f30f594718           | mulss               xmm0, dword ptr [edi + 0x18]
            //   f30f5cc8             | subss               xmm1, xmm0

        $sequence_7 = { f76b14 03f8 8b4560 13ca f76b18 03f8 8b455c }
            // n = 7, score = 100
            //   f76b14               | imul                dword ptr [ebx + 0x14]
            //   03f8                 | add                 edi, eax
            //   8b4560               | mov                 eax, dword ptr [ebp + 0x60]
            //   13ca                 | adc                 ecx, edx
            //   f76b18               | imul                dword ptr [ebx + 0x18]
            //   03f8                 | add                 edi, eax
            //   8b455c               | mov                 eax, dword ptr [ebp + 0x5c]

        $sequence_8 = { ff5004 48 8bcf 50 ff560c 8b17 8bcf }
            // n = 7, score = 100
            //   ff5004               | call                dword ptr [eax + 4]
            //   48                   | dec                 eax
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   ff560c               | call                dword ptr [esi + 0xc]
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   8bcf                 | mov                 ecx, edi

        $sequence_9 = { ff74241c 8b4608 8b4e04 48 f20f1044242c 23c2 6a00 }
            // n = 7, score = 100
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   48                   | dec                 eax
            //   f20f1044242c         | movsd               xmm0, qword ptr [esp + 0x2c]
            //   23c2                 | and                 eax, edx
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 7258112
}