rule win_oddjob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oddjob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oddjob"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 399da494ffff 7520 399d9c94ffff 7418 8bb59c94ffff 8b06 56 }
            // n = 7, score = 100
            //   399da494ffff         | cmp                 dword ptr [ebp - 0x6b5c], ebx
            //   7520                 | jne                 0x22
            //   399d9c94ffff         | cmp                 dword ptr [ebp - 0x6b64], ebx
            //   7418                 | je                  0x1a
            //   8bb59c94ffff         | mov                 esi, dword ptr [ebp - 0x6b64]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   56                   | push                esi

        $sequence_1 = { c6856affffff51 c6856bffffff8b c6856cffffff56 c6856dffffff14 }
            // n = 4, score = 100
            //   c6856affffff51       | mov                 byte ptr [ebp - 0x96], 0x51
            //   c6856bffffff8b       | mov                 byte ptr [ebp - 0x95], 0x8b
            //   c6856cffffff56       | mov                 byte ptr [ebp - 0x94], 0x56
            //   c6856dffffff14       | mov                 byte ptr [ebp - 0x93], 0x14

        $sequence_2 = { 888592fcffff c68593fcffff53 c68594fcffff3e c68595fcffff5b }
            // n = 4, score = 100
            //   888592fcffff         | mov                 byte ptr [ebp - 0x36e], al
            //   c68593fcffff53       | mov                 byte ptr [ebp - 0x36d], 0x53
            //   c68594fcffff3e       | mov                 byte ptr [ebp - 0x36c], 0x3e
            //   c68595fcffff5b       | mov                 byte ptr [ebp - 0x36b], 0x5b

        $sequence_3 = { 8d85fefdffff 57 50 c785ccf7ffff01000000 89bdc0f7ffff e8???????? }
            // n = 6, score = 100
            //   8d85fefdffff         | lea                 eax, [ebp - 0x202]
            //   57                   | push                edi
            //   50                   | push                eax
            //   c785ccf7ffff01000000     | mov    dword ptr [ebp - 0x834], 1
            //   89bdc0f7ffff         | mov                 dword ptr [ebp - 0x840], edi
            //   e8????????           |                     

        $sequence_4 = { 8b7d08 57 8bcb e8???????? 57 8945e0 897d08 }
            // n = 7, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   57                   | push                edi
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   897d08               | mov                 dword ptr [ebp + 8], edi

        $sequence_5 = { 0f844c080000 663d7800 0f8442080000 663d5800 0f8438080000 83a598fbffff00 8bb5dcfbffff }
            // n = 7, score = 100
            //   0f844c080000         | je                  0x852
            //   663d7800             | cmp                 ax, 0x78
            //   0f8442080000         | je                  0x848
            //   663d5800             | cmp                 ax, 0x58
            //   0f8438080000         | je                  0x83e
            //   83a598fbffff00       | and                 dword ptr [ebp - 0x468], 0
            //   8bb5dcfbffff         | mov                 esi, dword ptr [ebp - 0x424]

        $sequence_6 = { 889dd3feffff 889dd4feffff 889dd5feffff c685d6feffff56 }
            // n = 4, score = 100
            //   889dd3feffff         | mov                 byte ptr [ebp - 0x12d], bl
            //   889dd4feffff         | mov                 byte ptr [ebp - 0x12c], bl
            //   889dd5feffff         | mov                 byte ptr [ebp - 0x12b], bl
            //   c685d6feffff56       | mov                 byte ptr [ebp - 0x12a], 0x56

        $sequence_7 = { f7f7 8b4508 8a0401 32c2 88040e 41 8955fc }
            // n = 7, score = 100
            //   f7f7                 | div                 edi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a0401               | mov                 al, byte ptr [ecx + eax]
            //   32c2                 | xor                 al, dl
            //   88040e               | mov                 byte ptr [esi + ecx], al
            //   41                   | inc                 ecx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_8 = { c68558fcffff8b c68559fcffff76 c6855afcffff10 c6855bfcffff01 c6855cfcffffc3 c6855dfcffff53 }
            // n = 6, score = 100
            //   c68558fcffff8b       | mov                 byte ptr [ebp - 0x3a8], 0x8b
            //   c68559fcffff76       | mov                 byte ptr [ebp - 0x3a7], 0x76
            //   c6855afcffff10       | mov                 byte ptr [ebp - 0x3a6], 0x10
            //   c6855bfcffff01       | mov                 byte ptr [ebp - 0x3a5], 1
            //   c6855cfcffffc3       | mov                 byte ptr [ebp - 0x3a4], 0xc3
            //   c6855dfcffff53       | mov                 byte ptr [ebp - 0x3a3], 0x53

        $sequence_9 = { 83cfff f7f7 8b4508 8a0401 32c2 88040e }
            // n = 6, score = 100
            //   83cfff               | or                  edi, 0xffffffff
            //   f7f7                 | div                 edi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a0401               | mov                 al, byte ptr [ecx + eax]
            //   32c2                 | xor                 al, dl
            //   88040e               | mov                 byte ptr [esi + ecx], al

    condition:
        7 of them and filesize < 221184
}