rule win_oni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oni."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oni"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8c24f0000000 c78424040100000f000000 c784240001000000000000 c68424f000000000 }
            // n = 4, score = 200
            //   8d8c24f0000000       | lea                 ecx, [esp + 0xf0]
            //   c78424040100000f000000     | mov    dword ptr [esp + 0x104], 0xf
            //   c784240001000000000000     | mov    dword ptr [esp + 0x100], 0
            //   c68424f000000000     | mov                 byte ptr [esp + 0xf0], 0

        $sequence_1 = { 83f904 0f828d000000 83f923 0f8789000000 8bc8 }
            // n = 5, score = 200
            //   83f904               | cmp                 ecx, 4
            //   0f828d000000         | jb                  0x93
            //   83f923               | cmp                 ecx, 0x23
            //   0f8789000000         | ja                  0x8f
            //   8bc8                 | mov                 ecx, eax

        $sequence_2 = { 8b4804 8d41f8 89840d14ffffff 8d4580 50 c74580b83a4300 e8???????? }
            // n = 7, score = 200
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41f8               | lea                 eax, [ecx - 8]
            //   89840d14ffffff       | mov                 dword ptr [ebp + ecx - 0xec], eax
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   c74580b83a4300       | mov                 dword ptr [ebp - 0x80], 0x433ab8
            //   e8????????           |                     

        $sequence_3 = { 7603 6a26 58 0fb60c8536bf4200 0fb6348537bf4200 8bf9 8985b4f8ffff }
            // n = 7, score = 200
            //   7603                 | jbe                 5
            //   6a26                 | push                0x26
            //   58                   | pop                 eax
            //   0fb60c8536bf4200     | movzx               ecx, byte ptr [eax*4 + 0x42bf36]
            //   0fb6348537bf4200     | movzx               esi, byte ptr [eax*4 + 0x42bf37]
            //   8bf9                 | mov                 edi, ecx
            //   8985b4f8ffff         | mov                 dword ptr [ebp - 0x74c], eax

        $sequence_4 = { 7420 6bc618 57 8db86c854300 57 ff15???????? }
            // n = 6, score = 200
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db86c854300         | lea                 edi, [eax + 0x43856c]
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_5 = { 8bc1 83e13f c1f806 6bc930 8b048590884300 f644082801 7406 }
            // n = 7, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   83e13f               | and                 ecx, 0x3f
            //   c1f806               | sar                 eax, 6
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048590884300       | mov                 eax, dword ptr [eax*4 + 0x438890]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8

        $sequence_6 = { 83e03f c1ff06 6bd830 8b04bd90884300 f644032801 7444 837c0318ff }
            // n = 7, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bd830               | imul                ebx, eax, 0x30
            //   8b04bd90884300       | mov                 eax, dword ptr [edi*4 + 0x438890]
            //   f644032801           | test                byte ptr [ebx + eax + 0x28], 1
            //   7444                 | je                  0x46
            //   837c0318ff           | cmp                 dword ptr [ebx + eax + 0x18], -1

        $sequence_7 = { 8b550c 3b5df0 0f82cefeffff eb20 8b0c8d90884300 }
            // n = 5, score = 200
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   3b5df0               | cmp                 ebx, dword ptr [ebp - 0x10]
            //   0f82cefeffff         | jb                  0xfffffed4
            //   eb20                 | jmp                 0x22
            //   8b0c8d90884300       | mov                 ecx, dword ptr [ecx*4 + 0x438890]

        $sequence_8 = { 8d85f8fdffff 6a00 50 e8???????? 83c40c 8d85f8feffff }
            // n = 6, score = 200
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]

        $sequence_9 = { eb02 33f6 53 8d4dd0 e8???????? 807dd400 750a }
            // n = 7, score = 200
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   53                   | push                ebx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   807dd400             | cmp                 byte ptr [ebp - 0x2c], 0
            //   750a                 | jne                 0xc

    condition:
        7 of them and filesize < 499712
}