rule win_onionduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.onionduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.onionduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8b7510 56 894df8 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_1 = { 8b0f 83c404 5f 8919 }
            // n = 4, score = 200
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   8919                 | mov                 dword ptr [ecx], ebx

        $sequence_2 = { c645fc01 bf08000000 85c0 7417 8b4dd4 }
            // n = 5, score = 200
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   bf08000000           | mov                 edi, 8
            //   85c0                 | test                eax, eax
            //   7417                 | je                  0x19
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

        $sequence_3 = { c20c00 8b4d08 8b11 8b4214 56 6a01 ffd0 }
            // n = 7, score = 200
            //   c20c00               | ret                 0xc
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   56                   | push                esi
            //   6a01                 | push                1
            //   ffd0                 | call                eax

        $sequence_4 = { 56 e8???????? 837de808 8bf0 720c 8b4dd4 51 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   837de808             | cmp                 dword ptr [ebp - 0x18], 8
            //   8bf0                 | mov                 esi, eax
            //   720c                 | jb                  0xe
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx

        $sequence_5 = { 8a08 40 84c9 75f9 2bc2 750e }
            // n = 6, score = 200
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   750e                 | jne                 0x10

        $sequence_6 = { ffd0 8b13 894508 8b4208 56 }
            // n = 5, score = 200
            //   ffd0                 | call                eax
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   56                   | push                esi

        $sequence_7 = { c20400 8b03 50 e8???????? 83c404 56 ff15???????? }
            // n = 7, score = 200
            //   c20400               | ret                 4
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_8 = { 8b4dfc 33cd e8???????? 8be5 5d c20400 837df408 }
            // n = 7, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   837df408             | cmp                 dword ptr [ebp - 0xc], 8

        $sequence_9 = { 8b4d08 2bd0 c1fa03 3bd1 770a 68???????? e8???????? }
            // n = 7, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   2bd0                 | sub                 edx, eax
            //   c1fa03               | sar                 edx, 3
            //   3bd1                 | cmp                 edx, ecx
            //   770a                 | ja                  0xc
            //   68????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 671744
}