rule win_op_blockbuster_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.op_blockbuster."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.op_blockbuster"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c701???????? 8b497c 85c9 7407 51 }
            // n = 5, score = 800
            //   c701????????         |                     
            //   8b497c               | dec                 eax
            //   85c9                 | mov                 dword ptr [ebp + 0x4f0], eax
            //   7407                 | dec                 esp
            //   51                   | mov                 esi, ecx

        $sequence_1 = { 57 683c400000 6a40 ff15???????? }
            // n = 4, score = 800
            //   57                   | cmp                 al, 0x72
            //   683c400000           | cmp                 al, 0x69
            //   6a40                 | jl                  0xc
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 85c0 7407 83f802 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   85c0                 | cmp                 al, 0x70
            //   7407                 | jg                  8
            //   83f802               | dec                 eax

        $sequence_3 = { ff15???????? 6808400000 6a40 ff15???????? }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6808400000           | dec                 esp
            //   6a40                 | mov                 edi, edx
            //   ff15????????         |                     

        $sequence_4 = { 56 e8???????? 68???????? 56 a3???????? e8???????? 83c440 }
            // n = 7, score = 800
            //   56                   | push                edi
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                0x403c
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c440               | push                0x40

        $sequence_5 = { f3ab 66ab aa 5f 85f6 5e }
            // n = 6, score = 800
            //   f3ab                 | cmp                 al, 0x70
            //   66ab                 | jg                  8
            //   aa                   | add                 al, 9
            //   5f                   | jmp                 0xe
            //   85f6                 | cmp                 al, 0x69
            //   5e                   | jl                  0xc

        $sequence_6 = { 8a08 80f920 7505 83c021 }
            // n = 4, score = 800
            //   8a08                 | test                esi, esi
            //   80f920               | pop                 esi
            //   7505                 | test                eax, eax
            //   83c021               | je                  0xb

        $sequence_7 = { 8d45fc 6a04 50 57 ff15???????? }
            // n = 5, score = 700
            //   8d45fc               | pop                 ecx
            //   6a04                 | pop                 ecx
            //   50                   | push                esi
            //   57                   | push                eax
            //   ff15????????         |                     

        $sequence_8 = { 85c0 7412 68???????? 50 e8???????? 59 a3???????? }
            // n = 7, score = 700
            //   85c0                 | test                eax, eax
            //   7412                 | je                  9
            //   68????????           |                     
            //   50                   | cmp                 eax, 2
            //   e8????????           |                     
            //   59                   | mov                 ecx, dword ptr [ecx + 0x7c]
            //   a3????????           |                     

        $sequence_9 = { 56 50 8d45fc 6a04 }
            // n = 4, score = 700
            //   56                   | push                0x4000
            //   50                   | push                0
            //   8d45fc               | test                eax, eax
            //   6a04                 | je                  0x16

        $sequence_10 = { 3c70 7f04 0409 eb06 }
            // n = 4, score = 500
            //   3c70                 | cmp                 al, 0x70
            //   7f04                 | jg                  6
            //   0409                 | add                 al, 9
            //   eb06                 | jmp                 8

        $sequence_11 = { 3c69 7c08 3c70 7f04 }
            // n = 4, score = 500
            //   3c69                 | cmp                 al, 0x69
            //   7c08                 | jl                  0xa
            //   3c70                 | cmp                 al, 0x70
            //   7f04                 | jg                  6

        $sequence_12 = { 8bf0 ff15???????? 85f6 7404 85c0 }
            // n = 5, score = 300
            //   8bf0                 | add                 esp, 0x14
            //   ff15????????         |                     
            //   85f6                 | mov                 eax, 1
            //   7404                 | push                ebx
            //   85c0                 | push                1

        $sequence_13 = { 4863c1 48ffc7 448bc2 88940460010000 0fb607 84c0 }
            // n = 6, score = 300
            //   4863c1               | dec                 eax
            //   48ffc7               | lea                 edx, [esp + 0x60]
            //   448bc2               | xor                 eax, eax
            //   88940460010000       | mov                 edi, eax
            //   0fb607               | dec                 eax
            //   84c0                 | lea                 ecx, [ebp + 0x2d0]

        $sequence_14 = { 33c0 8bf8 488d8dd0020000 4863df ff15???????? 488d4c3302 488d95d0020000 }
            // n = 7, score = 300
            //   33c0                 | xor                 edx, edx
            //   8bf8                 | inc                 ecx
            //   488d8dd0020000       | mov                 eax, 0x103
            //   4863df               | mov                 byte ptr [ebp + 0x110], 0
            //   ff15????????         |                     
            //   488d4c3302           | inc                 ebp
            //   488d95d0020000       | xor                 esp, esp

        $sequence_15 = { a3???????? 5e c3 68???????? ff15???????? 85c0 7412 }
            // n = 7, score = 300
            //   a3????????           |                     
            //   5e                   | je                  0x16
            //   c3                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | je                  0x14
            //   7412                 | push                eax

        $sequence_16 = { 57 e8???????? 56 e8???????? 83c414 b801000000 }
            // n = 6, score = 300
            //   57                   | push                esi
            //   e8????????           |                     
            //   56                   | mov                 eax, esi
            //   e8????????           |                     
            //   83c414               | pop                 edi
            //   b801000000           | pop                 esi

        $sequence_17 = { 666666660f1f840000000000 0fb603 48ffc3 884419ff 84c0 75f2 488d9580010000 }
            // n = 7, score = 300
            //   666666660f1f840000000000     | lea    edx, [esp + 0x2c0]
            //   0fb603               | nop                 word ptr [eax + eax]
            //   48ffc3               | movzx               eax, byte ptr [ebx]
            //   884419ff             | dec                 eax
            //   84c0                 | inc                 ebx
            //   75f2                 | mov                 byte ptr [ecx + ebx - 1], al
            //   488d9580010000       | test                al, al

        $sequence_18 = { 488d8d11010000 33d2 41b803010000 c6851001000000 e8???????? 4533e4 488d542460 }
            // n = 7, score = 300
            //   488d8d11010000       | test                al, al
            //   33d2                 | jne                 0xfffffff1
            //   41b803010000         | cmp                 byte ptr [edi], 0x20
            //   c6851001000000       | je                  0xf
            //   e8????????           |                     
            //   4533e4               | dec                 eax
            //   488d542460           | lea                 ecx, [ebp + 0x111]

        $sequence_19 = { 8bc6 5f 5e c3 33c0 6a00 }
            // n = 6, score = 300
            //   8bc6                 | cmp                 cl, 0x20
            //   5f                   | jne                 7
            //   5e                   | add                 eax, 0x21
            //   c3                   | jmp                 0xc
            //   33c0                 | mov                 cl, byte ptr [eax]
            //   6a00                 | cmp                 cl, 0x20

        $sequence_20 = { 6a00 ff15???????? 8bf8 85ff 7504 5f 5e }
            // n = 7, score = 300
            //   6a00                 | push                ebx
            //   ff15????????         |                     
            //   8bf8                 | xor                 ebx, ebx
            //   85ff                 | push                esi
            //   7504                 | push                edi
            //   5f                   | jne                 0x48
            //   5e                   | mov                 eax, esi

        $sequence_21 = { 89442440 888424c0020000 e8???????? 488d9424c0020000 }
            // n = 4, score = 300
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   888424c0020000       | mov                 byte ptr [esp + 0x2c0], al
            //   e8????????           |                     
            //   488d9424c0020000     | dec                 eax

        $sequence_22 = { c3 56 53 6a01 57 e8???????? }
            // n = 6, score = 300
            //   c3                   | xor                 eax, eax
            //   56                   | xor                 eax, eax
            //   53                   | jmp                 0xfffffffc
            //   6a01                 | push                ebx
            //   57                   | xor                 ebx, ebx
            //   e8????????           |                     

        $sequence_23 = { c3 33c0 ebf8 53 33db 391d???????? 56 }
            // n = 7, score = 300
            //   c3                   | test                esi, esi
            //   33c0                 | push                edi
            //   ebf8                 | push                0x403c
            //   53                   | push                0x40
            //   33db                 | stosw               word ptr es:[edi], ax
            //   391d????????         |                     
            //   56                   | stosb               byte ptr es:[edi], al

        $sequence_24 = { 0fb607 48ffc1 84c0 75ea 803f20 740a }
            // n = 6, score = 300
            //   0fb607               | jne                 0xfffffff4
            //   48ffc1               | dec                 eax
            //   84c0                 | lea                 edx, [ebp + 0x180]
            //   75ea                 | movzx               eax, byte ptr [edi]
            //   803f20               | dec                 eax
            //   740a                 | inc                 ecx

        $sequence_25 = { 68???????? 56 e8???????? 56 e8???????? 83c438 }
            // n = 6, score = 300
            //   68????????           |                     
            //   56                   | pop                 edi
            //   e8????????           |                     
            //   56                   | pop                 esi
            //   e8????????           |                     
            //   83c438               | ret                 

        $sequence_26 = { 897de0 394508 7c1f 3934bdd8974400 }
            // n = 4, score = 200
            //   897de0               | je                  8
            //   394508               | test                eax, eax
            //   7c1f                 | push                edi
            //   3934bdd8974400       | push                esi

        $sequence_27 = { 83e03f c1ff06 6bd830 8b04bdd8974400 f644032801 }
            // n = 5, score = 200
            //   83e03f               | push                1
            //   c1ff06               | push                edi
            //   6bd830               | push                esi
            //   8b04bdd8974400       | add                 esp, 0x14
            //   f644032801           | test                esi, esi

        $sequence_28 = { 6bc830 8b0495d8974400 8b440818 83f8ff 7409 83f8fe 7404 }
            // n = 7, score = 200
            //   6bc830               | add                 esp, 0x14
            //   8b0495d8974400       | mov                 eax, 1
            //   8b440818             | push                esi
            //   83f8ff               | push                esi
            //   7409                 | add                 esp, 0x38
            //   83f8fe               | ret                 
            //   7404                 | push                esi

        $sequence_29 = { 50 68???????? 6a05 8d856cffffff 57 50 }
            // n = 6, score = 100
            //   50                   | push                4
            //   68????????           |                     
            //   6a05                 | push                eax
            //   8d856cffffff         | push                edi
            //   57                   | push                esi
            //   50                   | push                eax

        $sequence_30 = { 8bcb 8d84240c0c0000 83e103 50 }
            // n = 4, score = 100
            //   8bcb                 | ret                 
            //   8d84240c0c0000       | push                esi
            //   83e103               | push                ebx
            //   50                   | push                1

        $sequence_31 = { c745d403000000 8975d8 8b08 52 }
            // n = 4, score = 100
            //   c745d403000000       | pop                 ecx
            //   8975d8               | pop                 ecx
            //   8b08                 | push                eax
            //   52                   | lea                 eax, [ebp - 4]

        $sequence_32 = { 8d85e0fdffff d1fe 4e 56 50 }
            // n = 5, score = 100
            //   8d85e0fdffff         | lea                 eax, [ebp - 4]
            //   d1fe                 | push                4
            //   4e                   | push                eax
            //   56                   | pop                 esi
            //   50                   | ret                 

        $sequence_33 = { e8???????? 6800040000 56 ff742414 ff15???????? 5f }
            // n = 6, score = 100
            //   e8????????           |                     
            //   6800040000           | push                4
            //   56                   | push                eax
            //   ff742414             | push                edi
            //   ff15????????         |                     
            //   5f                   | lea                 eax, [ebp - 4]

    condition:
        7 of them and filesize < 74309632
}