rule win_opachki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.opachki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.opachki"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb69 8b5508 8b4904 53 }
            // n = 4, score = 300
            //   eb69                 | jmp                 0x6b
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   53                   | push                ebx

        $sequence_1 = { 57 6a0d 68???????? 8d4ddc e8???????? 68ff000000 }
            // n = 6, score = 300
            //   57                   | push                edi
            //   6a0d                 | push                0xd
            //   68????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   68ff000000           | push                0xff

        $sequence_2 = { c3 55 8bec 81ec00010000 ff7508 }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec00010000         | sub                 esp, 0x100
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { ff15???????? 8d8500ffffff 50 ff7508 e8???????? 59 59 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_4 = { 034604 50 ff15???????? 8b4708 }
            // n = 4, score = 300
            //   034604               | add                 eax, dword ptr [esi + 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4708               | mov                 eax, dword ptr [edi + 8]

        $sequence_5 = { 57 8b7d0c 8a0f 894508 84c9 744d 8a10 }
            // n = 7, score = 300
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8a0f                 | mov                 cl, byte ptr [edi]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   84c9                 | test                cl, cl
            //   744d                 | je                  0x4f
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_6 = { 894708 c6040800 5b 5f }
            // n = 4, score = 300
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   c6040800             | mov                 byte ptr [eax + ecx], 0
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_7 = { 33c0 c706???????? 894608 89460c 894604 e8???????? 8bc6 }
            // n = 7, score = 300
            //   33c0                 | xor                 eax, eax
            //   c706????????         |                     
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 2b442424 aa 8944241c 61 }
            // n = 4, score = 200
            //   2b442424             | sub                 eax, dword ptr [esp + 0x24]
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   61                   | popal               

        $sequence_9 = { ebc1 3c67 7507 884705 b301 ebb6 }
            // n = 6, score = 200
            //   ebc1                 | jmp                 0xffffffc3
            //   3c67                 | cmp                 al, 0x67
            //   7507                 | jne                 9
            //   884705               | mov                 byte ptr [edi + 5], al
            //   b301                 | mov                 bl, 1
            //   ebb6                 | jmp                 0xffffffb8

        $sequence_10 = { 00f0 8a0c01 f6c101 0f84b9000000 ac 884708 88c5 }
            // n = 7, score = 200
            //   00f0                 | add                 al, dh
            //   8a0c01               | mov                 cl, byte ptr [ecx + eax]
            //   f6c101               | test                cl, 1
            //   0f84b9000000         | je                  0xbf
            //   ac                   | lodsb               al, byte ptr [esi]
            //   884708               | mov                 byte ptr [edi + 8], al
            //   88c5                 | mov                 ch, al

        $sequence_11 = { 31db 99 b125 f3aa }
            // n = 4, score = 200
            //   31db                 | xor                 ebx, ebx
            //   99                   | cdq                 
            //   b125                 | mov                 cl, 0x25
            //   f3aa                 | rep stosb           byte ptr es:[edi], al

        $sequence_12 = { 83c140 eb0a 3ca0 7206 }
            // n = 4, score = 200
            //   83c140               | add                 ecx, 0x40
            //   eb0a                 | jmp                 0xc
            //   3ca0                 | cmp                 al, 0xa0
            //   7206                 | jb                  8

        $sequence_13 = { 08db 752b 46 88470c 88c4 c0ec06 }
            // n = 6, score = 200
            //   08db                 | or                  bl, bl
            //   752b                 | jne                 0x2d
            //   46                   | inc                 esi
            //   88470c               | mov                 byte ptr [edi + 0xc], al
            //   88c4                 | mov                 ah, al
            //   c0ec06               | shr                 ah, 6

        $sequence_14 = { 08db 7409 80fe06 750b }
            // n = 4, score = 200
            //   08db                 | or                  bl, bl
            //   7409                 | je                  0xb
            //   80fe06               | cmp                 dh, 6
            //   750b                 | jne                 0xd

    condition:
        7 of them and filesize < 122880
}