rule win_open_carrot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.open_carrot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.open_carrot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66894110 837de801 0f8588000000 488bc7 80bdfa00000001 7545 0f1f440000 }
            // n = 7, score = 100
            //   66894110             | nop                 dword ptr [eax]
            //   837de801             | dec                 esp
            //   0f8588000000         | cmp                 dword ptr [esp + esi*8 + 0x68], esi
            //   488bc7               | mov                 edx, dword ptr [esp + 0x70]
            //   80bdfa00000001       | inc                 ecx
            //   7545                 | mov                 ecx, edi
            //   0f1f440000           | test                edx, edx

        $sequence_1 = { e8???????? 4863d7 4c8d05dbdc0f00 41b9e3010000 498bce e8???????? 418bc7 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4863d7               | mov                 ecx, dword ptr [ebp + 0x28]
            //   4c8d05dbdc0f00       | dec                 eax
            //   41b9e3010000         | lea                 edx, [0xae9be]
            //   498bce               | inc                 esp
            //   e8????????           |                     
            //   418bc7               | mov                 esi, eax

        $sequence_2 = { 80fb00 0f846c000000 4d31e5 4881e700080000 49c7c501000000 4989eb 4881e190000000 }
            // n = 7, score = 100
            //   80fb00               | dec                 eax
            //   0f846c000000         | mov                 ebp, eax
            //   4d31e5               | dec                 eax
            //   4881e700080000       | test                eax, eax
            //   49c7c501000000       | je                  0x1163
            //   4989eb               | xor                 edx, edx
            //   4881e190000000       | dec                 eax

        $sequence_3 = { 55 48bd612fef7700000000 48016c2408 5d 8f042b 48812c2b612fef77 50 }
            // n = 7, score = 100
            //   55                   | lea                 eax, [ebx + 1]
            //   48bd612fef7700000000     | dec    esp
            //   48016c2408           | arpl                ax, ax
            //   5d                   | dec                 eax
            //   8f042b               | lea                 edx, [ebp + 0x450]
            //   48812c2b612fef77     | dec                 eax
            //   50                   | lea                 ecx, [ebp + 0x660]

        $sequence_4 = { 4d29c9 0137 4981e13f000000 4889eb 4881c306010000 4d09c1 2933 }
            // n = 7, score = 100
            //   4d29c9               | dec                 eax
            //   0137                 | mov                 ecx, dword ptr [ebx + 0x90]
            //   4981e13f000000       | dec                 eax
            //   4889eb               | mov                 eax, dword ptr [ebx + 0x1b0]
            //   4881c306010000       | inc                 dword ptr [eax + 0x74]
            //   4d09c1               | dec                 eax
            //   2933                 | lea                 eax, [0xffff7758]

        $sequence_5 = { 8bd6 488d8d10070000 e8???????? 85c0 400f94c7 eb03 4032ff }
            // n = 7, score = 100
            //   8bd6                 | dec                 eax
            //   488d8d10070000       | mov                 edx, 0x12
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   400f94c7             | add                 edi, 0x40
            //   eb03                 | dec                 eax
            //   4032ff               | mov                 eax, ebp

        $sequence_6 = { e8???????? 498bcd e8???????? 448b442434 4c8d0dc8cb0d00 ba72000000 c744242082020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498bcd               | inc                 ebp
            //   e8????????           |                     
            //   448b442434           | mov                 bl, byte ptr [ebp]
            //   4c8d0dc8cb0d00       | inc                 ecx
            //   ba72000000           | cmp                 bl, 0x43
            //   c744242082020000     | jbe                 0x187c

        $sequence_7 = { 4c8d8594080000 4489b520030000 bacc010000 488d8d24030000 e8???????? 448bad20030000 448b4c2438 }
            // n = 7, score = 100
            //   4c8d8594080000       | inc                 esp
            //   4489b520030000       | mov                 edi, dword ptr [ebp + 0x150]
            //   bacc010000           | inc                 esp
            //   488d8d24030000       | mov                 esp, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   448bad20030000       | inc                 esp
            //   448b4c2438           | mov                 ebp, dword ptr [esp + 0x34]

        $sequence_8 = { 68bc5c574f 4150 4d89f0 4150 8f442408 4158 8f0424 }
            // n = 7, score = 100
            //   68bc5c574f           | cmp                 ebx, eax
            //   4150                 | jl                  0xb30
            //   4d89f0               | inc                 ecx
            //   4150                 | mov                 eax, 0x1a8
            //   8f442408             | dec                 eax
            //   4158                 | lea                 edx, [0xd3c5c]
            //   8f0424               | inc                 ebx

        $sequence_9 = { 488d1575381000 41b872010000 e8???????? 48638300020000 4c89bcc380000000 48638300020000 488b6c2448 }
            // n = 7, score = 100
            //   488d1575381000       | mov                 ecx, 0x200
            //   41b872010000         | dec                 ecx
            //   e8????????           |                     
            //   48638300020000       | add                 ebp, ebp
            //   4c89bcc380000000     | dec                 ecx
            //   48638300020000       | mov                 edi, 0x12
            //   488b6c2448           | inc                 ecx

    condition:
        7 of them and filesize < 8377344
}