rule win_orcarat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.orcarat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orcarat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a0d???????? 8a15???????? 346f 80f170 8844245e a1???????? 884c245c }
            // n = 7, score = 200
            //   8a0d????????         |                     
            //   8a15????????         |                     
            //   346f                 | xor                 al, 0x6f
            //   80f170               | xor                 cl, 0x70
            //   8844245e             | mov                 byte ptr [esp + 0x5e], al
            //   a1????????           |                     
            //   884c245c             | mov                 byte ptr [esp + 0x5c], cl

        $sequence_1 = { 85c0 755a 57 8dbbb0010000 83c9ff 8d9534020000 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   755a                 | jne                 0x5c
            //   57                   | push                edi
            //   8dbbb0010000         | lea                 edi, [ebx + 0x1b0]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8d9534020000         | lea                 edx, [ebp + 0x234]

        $sequence_2 = { 51 68???????? 53 56 ffd5 85c0 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   68????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8bcd 6a00 e8???????? 85c0 7507 5f }
            // n = 6, score = 200
            //   8bcd                 | mov                 ecx, ebp
            //   6a00                 | push                0
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   5f                   | pop                 edi

        $sequence_4 = { c21000 8d442420 6a00 8d4c2418 50 51 }
            // n = 6, score = 200
            //   c21000               | ret                 0x10
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   6a00                 | push                0
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_5 = { 6a01 8bcd c7432801000000 896c241c e8???????? }
            // n = 5, score = 200
            //   6a01                 | push                1
            //   8bcd                 | mov                 ecx, ebp
            //   c7432801000000       | mov                 dword ptr [ebx + 0x28], 1
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp
            //   e8????????           |                     

        $sequence_6 = { 8b942408080000 56 8bf1 57 8bfa 83c9ff 33c0 }
            // n = 7, score = 200
            //   8b942408080000       | mov                 edx, dword ptr [esp + 0x808]
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 5e 81c404080000 c20400 8d54240e 8bce 52 }
            // n = 6, score = 200
            //   5e                   | pop                 esi
            //   81c404080000         | add                 esp, 0x804
            //   c20400               | ret                 4
            //   8d54240e             | lea                 edx, [esp + 0xe]
            //   8bce                 | mov                 ecx, esi
            //   52                   | push                edx

        $sequence_8 = { f3a5 8bc8 83e103 f3a4 8d4c241c 51 e8???????? }
            // n = 7, score = 200
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_9 = { 0f84d1000000 80bc241c0400003f 0f8488000000 8bc3 8d94241c040000 2bc2 8dbc241c040000 }
            // n = 7, score = 200
            //   0f84d1000000         | je                  0xd7
            //   80bc241c0400003f     | cmp                 byte ptr [esp + 0x41c], 0x3f
            //   0f8488000000         | je                  0x8e
            //   8bc3                 | mov                 eax, ebx
            //   8d94241c040000       | lea                 edx, [esp + 0x41c]
            //   2bc2                 | sub                 eax, edx
            //   8dbc241c040000       | lea                 edi, [esp + 0x41c]

    condition:
        7 of them and filesize < 114688
}